/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.paginate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int INIT_VALUE = -1;
    private List<T> records = Collections.emptyList();
    private int pageNumber = -1;
    private int pageSize = -1;
    private long totalPage = -1L;
    private long totalRow = -1L;

    public static <T> Page<T> of(int pageNumber, int pageSize) {
        return new Page<T>(pageNumber, pageSize);
    }

    public static <T> Page<T> of(int pageNumber, int pageSize, long totalRow) {
        return new Page<T>(pageNumber, pageSize, totalRow);
    }

    public Page() {
    }

    public Page(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public Page(int pageNumber, int pageSize, long totalRow) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.totalRow = totalRow;
        this.totalPage = totalRow % (long)pageSize == 0L ? totalRow / (long)pageSize : totalRow / (long)pageSize + 1L;
    }

    public Page(List<T> records, int pageNumber, int pageSize, long totalRow) {
        this.records = records;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.totalRow = totalRow;
        this.totalPage = totalRow % (long)pageSize == 0L ? totalRow / (long)pageSize : totalRow / (long)pageSize + 1L;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public long getTotalRow() {
        return this.totalRow;
    }

    public void setTotalRow(long totalRow) {
        this.totalRow = totalRow;
        this.totalPage = totalRow % (long)this.pageSize == 0L ? totalRow / (long)this.pageSize : totalRow / (long)this.pageSize + 1L;
    }

    public <R> Page<R> map(Function<? super T, ? extends R> mapper) {
        Page<T> newPage = new Page<T>();
        newPage.pageNumber = this.pageNumber;
        newPage.pageSize = this.pageSize;
        newPage.totalPage = this.totalPage;
        newPage.totalRow = this.totalRow;
        if (this.records != null && !this.records.isEmpty()) {
            ArrayList<T> newRecords = new ArrayList<T>(this.records.size());
            for (T t : this.records) {
                newRecords.add(mapper.apply(t));
            }
            newPage.records = newRecords;
        }
        return newPage;
    }

    public String toString() {
        return "Page{pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", totalPage=" + this.totalPage + ", totalRow=" + this.totalRow + ", records=" + this.records + '}';
    }
}

