/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.SelectQueryTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class Join
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String TYPE_JOIN = " JOIN ";
    static final String TYPE_LEFT = " LEFT JOIN ";
    static final String TYPE_RIGHT = " RIGHT JOIN ";
    static final String TYPE_INNER = " INNER JOIN ";
    static final String TYPE_FULL = " FULL JOIN ";
    static final String TYPE_CROSS = " CROSS JOIN ";
    private final String type;
    private final QueryTable queryTable;
    private QueryCondition on;
    private boolean effective;

    public Join(String type, String table, boolean when) {
        this.type = type;
        this.queryTable = new QueryTable(table);
        this.effective = when;
    }

    public Join(String type, QueryWrapper queryWrapper, boolean when) {
        this.type = type;
        this.queryTable = new SelectQueryTable(queryWrapper);
        this.effective = when;
    }

    QueryTable getQueryTable() {
        return this.queryTable;
    }

    public void on(QueryCondition condition) {
        this.on = condition;
    }

    QueryCondition getOnCondition() {
        return this.on;
    }

    public boolean checkEffective() {
        return this.effective;
    }

    public void when(boolean when) {
        this.effective = when;
    }

    public void when(Supplier<Boolean> fn) {
        this.effective = fn.get();
    }

    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder(this.type);
        sql.append(this.queryTable.toSql(dialect));
        ArrayList<QueryTable> newQueryTables = new ArrayList<QueryTable>(queryTables);
        newQueryTables.add(this.queryTable);
        sql.append(" ON ").append(this.on.toSql(newQueryTables, dialect));
        return sql.toString();
    }
}

