/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import java.io.Serializable;
import java.util.List;

public class QueryOrderBy
implements Serializable {
    private QueryColumn queryColumn;
    private String orderType = "ASC";
    private boolean nullsFirst = false;
    private boolean nullsLast = false;

    protected QueryOrderBy() {
    }

    public QueryOrderBy(QueryColumn queryColumn, String orderType) {
        this.queryColumn = queryColumn;
        this.orderType = orderType;
    }

    public QueryOrderBy(QueryColumn queryColumn) {
        this.queryColumn = queryColumn;
    }

    public QueryOrderBy nullsFirst() {
        this.nullsFirst = true;
        this.nullsLast = false;
        return this;
    }

    public QueryOrderBy nullsLast() {
        this.nullsFirst = false;
        this.nullsLast = true;
        return this;
    }

    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        String sql = this.queryColumn.toConditionSql(queryTables, dialect) + " " + this.orderType;
        if (this.nullsFirst) {
            sql = sql + " NULLS FIRST";
        } else if (this.nullsLast) {
            sql = sql + " NULLS LAST";
        }
        return sql;
    }
}

