/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.query.Brackets;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.RawValue;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.EnumWrapper;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class WrapperUtil {
    static final Object[] NULL_PARA_ARRAY = new Object[0];

    WrapperUtil() {
    }

    static String buildAsAlias(String alias) {
        return StringUtil.isBlank(alias) ? "" : " AS " + alias;
    }

    static List<QueryWrapper> getChildSelect(QueryCondition condition) {
        ArrayList<QueryWrapper> list = null;
        while (condition != null) {
            if (condition.checkEffective()) {
                if (condition instanceof Brackets) {
                    List<QueryWrapper> childQueryWrapper = WrapperUtil.getChildSelect(((Brackets)condition).getChildCondition());
                    if (!childQueryWrapper.isEmpty()) {
                        if (list == null) {
                            list = new ArrayList();
                        }
                        list.addAll(childQueryWrapper);
                    }
                } else {
                    Object value = condition.getValue();
                    if (value instanceof QueryWrapper) {
                        if (list == null) {
                            list = new ArrayList<QueryWrapper>();
                        }
                        list.add((QueryWrapper)value);
                        list.addAll(((QueryWrapper)value).getChildSelect());
                    } else if (value != null && value.getClass().isArray()) {
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            Object arrayValue = Array.get(value, i);
                            if (!(arrayValue instanceof QueryWrapper)) continue;
                            if (list == null) {
                                list = new ArrayList();
                            }
                            list.add((QueryWrapper)arrayValue);
                            list.addAll(((QueryWrapper)arrayValue).getChildSelect());
                        }
                    }
                }
            }
            condition = condition.next;
        }
        return list == null ? Collections.emptyList() : list;
    }

    static Object[] getValues(QueryCondition condition) {
        if (condition == null) {
            return NULL_PARA_ARRAY;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        WrapperUtil.getValues(condition, params);
        return params.isEmpty() ? NULL_PARA_ARRAY : params.toArray();
    }

    private static void getValues(QueryCondition condition, List<Object> params) {
        if (condition == null) {
            return;
        }
        Object value = condition.getValue();
        if (value == null || value instanceof QueryColumn || value instanceof RawValue) {
            WrapperUtil.getValues(condition.next, params);
            return;
        }
        WrapperUtil.addParam(params, value);
        WrapperUtil.getValues(condition.next, params);
    }

    private static void addParam(List<Object> paras, Object value) {
        if (value == null) {
            paras.add(null);
        } else if (ClassUtil.isArray(value.getClass())) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                WrapperUtil.addParam(paras, Array.get(value, i));
            }
        } else if (value instanceof QueryWrapper) {
            Object[] valueArray = ((QueryWrapper)value).getValueArray();
            paras.addAll(Arrays.asList(valueArray));
        } else if (value.getClass().isEnum()) {
            EnumWrapper enumWrapper = new EnumWrapper(value.getClass());
            if (enumWrapper.hasEnumValueAnnotation()) {
                paras.add(enumWrapper.getEnumValue((Enum)value));
            } else {
                paras.add(value);
            }
        } else {
            paras.add(value);
        }
    }

    public static String getColumnTableName(List<QueryTable> queryTables, QueryTable queryTable) {
        if (queryTables == null) {
            return "";
        }
        if (queryTables.size() == 1 && queryTables.get(0).isSameTable(queryTable)) {
            return "";
        }
        QueryTable realTable = WrapperUtil.getRealTable(queryTables, queryTable);
        if (realTable == null) {
            return "";
        }
        return StringUtil.isNotBlank(realTable.alias) ? realTable.alias : realTable.name;
    }

    public static QueryTable getRealTable(List<QueryTable> queryTables, QueryTable queryTable) {
        if (CollectionUtil.isEmpty(queryTables)) {
            return queryTable;
        }
        if (queryTable == null && queryTables.size() == 1) {
            return queryTables.get(0);
        }
        for (QueryTable table : queryTables) {
            if (!table.isSameTable(queryTable)) continue;
            return table;
        }
        return queryTable;
    }
}

