/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.util.ConvertUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class ClassUtil {
    private static final List<String> PROXY_CLASS_NAMES = Arrays.asList("net.sf.cglib.proxy.Factory", "org.springframework.cglib.proxy.Factory", "javassist.util.proxy.ProxyObject", "org.apache.ibatis.javassist.util.proxy.ProxyObject");
    private static final String ENHANCER_BY = "$$EnhancerBy";
    private static final String JAVASSIST_BY = "_$$_";

    public static boolean isProxy(Class<?> clazz) {
        for (Class<?> cls : clazz.getInterfaces()) {
            if (!PROXY_CLASS_NAMES.contains(cls.getName())) continue;
            return true;
        }
        return Proxy.isProxyClass(clazz);
    }

    public static <T> Class<T> getUsefulClass(Class<T> clazz) {
        if (ClassUtil.isProxy(clazz)) {
            return ClassUtil.getJdkProxySuperClass(clazz);
        }
        String name = clazz.getName();
        if (name.contains(ENHANCER_BY) || name.contains(JAVASSIST_BY)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public static Class<?> wrap(Class<?> clazz) {
        if (clazz == null || !clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz.isArray() || clazz == int[].class || clazz == long[].class || clazz == short[].class || clazz == float[].class || clazz == double[].class;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<?>[] declaredConstructors;
            Constructor<?> defaultConstructor = null;
            Constructor<?> otherConstructor = null;
            for (Constructor<?> constructor : declaredConstructors = clazz.getDeclaredConstructors()) {
                if (constructor.getParameterCount() == 0) {
                    defaultConstructor = constructor;
                    continue;
                }
                if (!Modifier.isPublic(constructor.getModifiers())) continue;
                otherConstructor = constructor;
            }
            if (defaultConstructor != null) {
                return defaultConstructor.newInstance(new Object[0]);
            }
            if (otherConstructor != null) {
                Class<?>[] parameterTypes = otherConstructor.getParameterTypes();
                Object[] parameters = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters[i] = parameterTypes[i].isPrimitive() ? ConvertUtil.getPrimitiveDefaultValue(parameterTypes[i]) : null;
                }
                return (T)otherConstructor.newInstance(parameters);
            }
            throw new IllegalArgumentException("the class \"" + clazz.getName() + "\" has no constructor.");
        }
        catch (Exception e) {
            throw new RuntimeException("Can not newInstance class: " + clazz.getName());
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... paras) {
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                if (!ClassUtil.isMatchedParas(constructor, paras)) continue;
                Object ret = constructor.newInstance(paras);
                return (T)ret;
            }
            throw new IllegalArgumentException("Can not find constructor by paras: \"" + Arrays.toString(paras) + "\" in class[" + clazz.getName() + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isMatchedParas(Constructor<?> constructor, Object[] paras) {
        if (constructor.getParameterCount() == 0) {
            return paras == null || paras.length == 0;
        }
        if (constructor.getParameterCount() > 0 && (paras == null || paras.length != constructor.getParameterCount())) {
            return false;
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Object paraObject = paras[i];
            if (paraObject == null || parameterType.isAssignableFrom(paraObject.getClass())) continue;
            return false;
        }
        return true;
    }

    public static List<Field> getAllFields(Class<?> cl) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtil.doGetFields(cl, fields, null);
        return fields;
    }

    public static List<Field> getAllFields(Class<?> cl, Predicate<Field> predicate) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtil.doGetFields(cl, fields, predicate);
        return fields;
    }

    private static void doGetFields(Class<?> cl, List<Field> fields, Predicate<Field> predicate) {
        Field[] declaredFields;
        if (cl == null || cl == Object.class) {
            return;
        }
        for (Field declaredField : declaredFields = cl.getDeclaredFields()) {
            if (predicate != null && !predicate.test(declaredField)) continue;
            fields.add(declaredField);
        }
        ClassUtil.doGetFields(cl.getSuperclass(), fields, predicate);
    }

    public static List<Method> getAllMethods(Class<?> cl) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassUtil.doGetMethods(cl, methods, null);
        return methods;
    }

    public static List<Method> getAllMethods(Class<?> cl, Predicate<Method> predicate) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassUtil.doGetMethods(cl, methods, predicate);
        return methods;
    }

    private static void doGetMethods(Class<?> cl, List<Method> methods, Predicate<Method> predicate) {
        Method[] declaredMethods;
        if (cl == null || cl == Object.class) {
            return;
        }
        for (Method method : declaredMethods = cl.getDeclaredMethods()) {
            if (predicate != null && !predicate.test(method)) continue;
            methods.add(method);
        }
        ClassUtil.doGetMethods(cl.getSuperclass(), methods, predicate);
    }

    private static <T> Class<T> getJdkProxySuperClass(Class<T> clazz) {
        Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), clazz.getInterfaces());
        return proxyClass.getInterfaces()[0];
    }
}

