/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.annotation.EnumValue;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;

public class EnumWrapper<E extends Enum<E>> {
    private Class<?> enumClass;
    private Class<?> enumPropertyType;
    private E[] enums;
    private Field property;
    private Method getter;
    private boolean hasEnumValueAnnotation = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnumWrapper(Class<E> enumClass) {
        this.enumClass = enumClass;
        List<Field> allFields = ClassUtil.getAllFields(enumClass, field -> field.getAnnotation(EnumValue.class) != null);
        if (!allFields.isEmpty()) {
            this.hasEnumValueAnnotation = true;
        }
        if (!this.hasEnumValueAnnotation) return;
        Field field2 = allFields.get(0);
        String fieldGetterName = "get" + StringUtil.firstCharToUpperCase(field2.getName());
        List<Method> allMethods = ClassUtil.getAllMethods(enumClass, method -> {
            String methodName = method.getName();
            return methodName.equals(fieldGetterName);
        });
        this.enumPropertyType = ClassUtil.wrap(field2.getType());
        this.enums = (Enum[])enumClass.getEnumConstants();
        if (allMethods.isEmpty()) {
            if (!Modifier.isPublic(field2.getModifiers())) throw new IllegalStateException("Can not find \"" + fieldGetterName + "()\" method in enum: " + enumClass.getName());
            this.property = field2;
            return;
        } else {
            this.getter = allMethods.get(0);
        }
    }

    public Object getEnumValue(E object) {
        try {
            return this.getter != null ? this.getter.invoke(object, new Object[0]) : this.property.get(object);
        }
        catch (Exception e) {
            throw FlexExceptions.wrap(e);
        }
    }

    public E toEnum(Object value) {
        for (E e : this.enums) {
            if (!value.equals(this.getEnumValue(e))) continue;
            return e;
        }
        return null;
    }

    public Class<?> getEnumClass() {
        return this.enumClass;
    }

    public Class<?> getEnumPropertyType() {
        return this.enumPropertyType;
    }

    public E[] getEnums() {
        return this.enums;
    }

    public Field getProperty() {
        return this.property;
    }

    public Method getGetter() {
        return this.getter;
    }

    public boolean hasEnumValueAnnotation() {
        return this.hasEnumValueAnnotation;
    }
}

