/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect;

import com.mybatisflex.core.util.StringUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class KeywordWrap {
    public static final KeywordWrap NONE = new KeywordWrap("", ""){

        @Override
        public String wrap(String keyword) {
            return keyword;
        }
    };
    public static final KeywordWrap BACKQUOTE = new KeywordWrap("`", "`");
    public static final KeywordWrap DOUBLE_QUOTATION = new KeywordWrap("\"", "\"");
    public static final KeywordWrap SQUARE_BRACKETS = new KeywordWrap("[", "]");
    private boolean caseSensitive = false;
    private Set<String> keywords = Collections.emptySet();
    private final String prefix;
    private final String suffix;

    public KeywordWrap(String prefix, String suffix) {
        this(false, Collections.emptySet(), prefix, suffix);
    }

    public KeywordWrap(Set<String> keywords, String prefix, String suffix) {
        this(false, keywords, prefix, suffix);
    }

    public KeywordWrap(boolean caseSensitive, Set<String> keywords, String prefix, String suffix) {
        this.caseSensitive = caseSensitive;
        this.keywords = keywords;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public String wrap(String keyword) {
        if (StringUtil.isBlank(keyword) || "*".equals(keyword)) {
            return keyword;
        }
        if (this.caseSensitive || this.keywords.isEmpty() || this.keywords.contains(keyword.toUpperCase(Locale.ENGLISH))) {
            return this.prefix + keyword + this.suffix;
        }
        return keyword;
    }
}

