/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect.impl;

import com.mybatisflex.core.dialect.KeywordWrap;
import com.mybatisflex.core.dialect.LimitOffsetProcessor;
import com.mybatisflex.core.dialect.impl.CommonsDialectImpl;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public class OracleDialect
extends CommonsDialectImpl {
    private static final Set<String> keywords = CollectionUtil.newHashSet("ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "ARRAYLEN", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOTFOUND", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWLABEL", "ROWNUM", "ROWS", "START", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "SQLBUF", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2");

    public OracleDialect() {
        this(LimitOffsetProcessor.ORACLE);
    }

    public OracleDialect(LimitOffsetProcessor limitOffsetProcessor) {
        super(new KeywordWrap(keywords, "\"", "\""), limitOffsetProcessor);
    }

    @Override
    public String forInsertEntityBatch(TableInfo tableInfo, List<?> entities) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT ALL");
        String[] insertColumns = tableInfo.obtainInsertColumns(null, false);
        CharSequence[] warpedInsertColumns = new String[insertColumns.length];
        for (int i = 0; i < insertColumns.length; ++i) {
            warpedInsertColumns[i] = this.wrap(insertColumns[i]);
        }
        Map<String, String> onInsertColumns = tableInfo.getOnInsertColumns();
        for (int i = 0; i < entities.size(); ++i) {
            sql.append(" INTO ").append(tableInfo.getWrapSchemaAndTableName(this));
            sql.append(" (").append(StringUtil.join(", ", warpedInsertColumns)).append(")");
            sql.append(" VALUES ");
            StringJoiner stringJoiner = new StringJoiner(", ", "(", ")");
            for (String insertColumn : insertColumns) {
                if (onInsertColumns != null && onInsertColumns.containsKey(insertColumn)) {
                    stringJoiner.add(onInsertColumns.get(insertColumn));
                    continue;
                }
                stringJoiner.add("?");
            }
            sql.append(stringJoiner);
        }
        return sql.append(" SELECT 1 FROM DUAL").toString();
    }

    @Override
    public String forInsertBatchWithFirstRowColumns(String schema, String tableName, List<Row> rows) {
        StringBuilder fields = new StringBuilder();
        Row firstRow = rows.get(0);
        Set<String> attrs = firstRow.obtainModifyAttrs();
        int index = 0;
        for (String column : attrs) {
            fields.append(this.wrap(column));
            if (index != attrs.size() - 1) {
                fields.append(", ");
            }
            ++index;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT ALL");
        String tableNameWrap = StringUtil.isNotBlank(schema) ? this.wrap(this.getRealSchema(schema)) + "." + this.wrap(this.getRealTable(tableName)) : this.wrap(this.getRealTable(tableName));
        String questionStrings = this.buildQuestion(attrs.size(), true);
        for (int i = 0; i < rows.size(); ++i) {
            sql.append(" INTO ").append(tableNameWrap);
            sql.append(" (").append((CharSequence)fields).append(")");
            sql.append(" VALUES ").append(questionStrings);
        }
        return sql.append(" SELECT 1 FROM DUAL").toString();
    }
}

