/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mask;

import com.mybatisflex.core.mask.MaskProcessor;
import com.mybatisflex.core.mask.Masks;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class MaskManager {
    private static final Map<String, MaskProcessor> processorMap = new HashMap<String, MaskProcessor>();
    private static final ThreadLocal<Boolean> skipFlags = new ThreadLocal();

    private MaskManager() {
    }

    public static void registerMaskProcessor(String type, MaskProcessor processor) {
        processorMap.put(type, processor);
    }

    public static <T> T withoutMask(Supplier<T> supplier) {
        try {
            MaskManager.skipMask();
            T t = supplier.get();
            return t;
        }
        finally {
            MaskManager.restoreMask();
        }
    }

    public static void skipMask() {
        skipFlags.set(Boolean.TRUE);
    }

    public static void restoreMask() {
        skipFlags.remove();
    }

    public static Object mask(String type, Object data) {
        Boolean skipMask = skipFlags.get();
        if (skipMask != null && skipMask.booleanValue()) {
            return data;
        }
        MaskProcessor maskProcessor = processorMap.get(type);
        if (maskProcessor == null) {
            throw new IllegalStateException("Can not get mask processor for by type: " + type);
        }
        return maskProcessor.mask(data);
    }

    static {
        MaskManager.registerMaskProcessor("mobile", Masks.MOBILE_PROCESSOR);
        MaskManager.registerMaskProcessor("fixed_phone", Masks.FIXED_PHONE_PROCESSOR);
        MaskManager.registerMaskProcessor("id_card_number", Masks.ID_CARD_NUMBER_PROCESSOR);
        MaskManager.registerMaskProcessor("chinese_name", Masks.CHINESE_NAME_PROCESSOR);
        MaskManager.registerMaskProcessor("address", Masks.ADDRESS_PROCESSOR);
        MaskManager.registerMaskProcessor("email", Masks.EMAIL_PROCESSOR);
        MaskManager.registerMaskProcessor("password", Masks.PASSWORD_PROCESSOR);
        MaskManager.registerMaskProcessor("car_license", Masks.CAR_LICENSE_PROCESSOR);
        MaskManager.registerMaskProcessor("bank_card_number", Masks.BANK_CARD_PROCESSOR);
    }
}

