/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.transaction.TransactionContext;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.cursor.defaults.DefaultCursor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class FlexResultSetHandler
extends DefaultResultSetHandler {
    public FlexResultSetHandler(Executor executor, MappedStatement mappedStatement, ParameterHandler parameterHandler, ResultHandler<?> resultHandler, BoundSql boundSql, RowBounds rowBounds) {
        super(executor, mappedStatement, parameterHandler, resultHandler, boundSql, rowBounds);
    }

    public <E> Cursor<E> handleCursorResultSets(Statement stmt) throws SQLException {
        return new FlexCursor(super.handleCursorResultSets(stmt));
    }

    static class FlexCursor<T>
    extends DefaultCursor<T> {
        private Cursor originalCursor;

        public FlexCursor(Cursor cursor) {
            super(null, null, null, null);
            this.originalCursor = cursor;
            TransactionContext.holdCursor(cursor);
        }

        public void close() {
            if (TransactionContext.getXID() == null) {
                TransactionContext.releaseCursor();
            }
        }

        public boolean isOpen() {
            return this.originalCursor.isOpen();
        }

        public boolean isConsumed() {
            return this.originalCursor.isConsumed();
        }

        public int getCurrentIndex() {
            return this.originalCursor.getCurrentIndex();
        }

        public Iterator<T> iterator() {
            try {
                return this.originalCursor.iterator();
            }
            catch (IllegalStateException e) {
                if (TransactionContext.getXID() == null) {
                    throw new IllegalStateException(e.getMessage() + " Cursor must use in transaction.");
                }
                throw e;
            }
        }
    }
}

