/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.paginate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int INIT_VALUE = -1;
    private List<T> records = Collections.emptyList();
    private int pageNumber = -1;
    private int pageSize = -1;
    private long totalPage = -1L;
    private long totalRow = -1L;

    public static <T> Page<T> of(int pageNumber, int pageSize) {
        return new Page<T>(pageNumber, pageSize);
    }

    public static <T> Page<T> of(int pageNumber, int pageSize, long totalRow) {
        return new Page<T>(pageNumber, pageSize, totalRow);
    }

    public Page() {
    }

    public Page(int pageNumber, int pageSize) {
        this.setPageNumber(pageNumber);
        this.setPageSize(pageSize);
    }

    public Page(int pageNumber, int pageSize, long totalRow) {
        this.setPageNumber(pageNumber);
        this.setPageSize(pageSize);
        this.setTotalRow(totalRow);
    }

    public Page(List<T> records, int pageNumber, int pageSize, long totalRow) {
        this.setRecords(records);
        this.setPageNumber(pageNumber);
        this.setPageSize(pageSize);
        this.setTotalRow(totalRow);
    }

    public List<T> getRecords() {
        return this.records;
    }

    public void setRecords(List<T> records) {
        if (records == null) {
            records = Collections.emptyList();
        }
        this.records = records;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("pageNumber must greater than or equal 1\uff0ccurrent value is: " + pageNumber);
        }
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 0) {
            throw new IllegalArgumentException("pageSize must greater than or equal 0\uff0ccurrent value is: " + pageSize);
        }
        this.pageSize = pageSize;
        this.calcTotalPage();
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public long getTotalRow() {
        return this.totalRow;
    }

    public void setTotalRow(long totalRow) {
        if (totalRow < 0L) {
            throw new IllegalArgumentException("totalRow must greater than or equal 0\uff0ccurrent value is: " + totalRow);
        }
        this.totalRow = totalRow;
        this.calcTotalPage();
    }

    private void calcTotalPage() {
        if (this.totalPage == -1L && this.pageSize != -1 && this.totalRow != -1L) {
            this.totalPage = this.totalRow % (long)this.pageSize == 0L ? this.totalRow / (long)this.pageSize : this.totalRow / (long)this.pageSize + 1L;
        }
    }

    public <R> Page<R> map(Function<? super T, ? extends R> mapper) {
        Page<T> newPage = new Page<T>();
        newPage.pageNumber = this.pageNumber;
        newPage.pageSize = this.pageSize;
        newPage.totalPage = this.totalPage;
        newPage.totalRow = this.totalRow;
        if (this.records != null && !this.records.isEmpty()) {
            ArrayList<T> newRecords = new ArrayList<T>(this.records.size());
            for (T t : this.records) {
                newRecords.add(mapper.apply(t));
            }
            newPage.records = newRecords;
        }
        return newPage;
    }

    public String toString() {
        return "Page{pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", totalPage=" + this.totalPage + ", totalRow=" + this.totalRow + ", records=" + this.records + '}';
    }
}

