/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.RawFragment;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class CaseQueryColumn
extends QueryColumn
implements HasParamsColumn {
    private List<When> whens;
    private Object elseValue;

    void addWhen(When when) {
        if (this.whens == null) {
            this.whens = new ArrayList<When>();
        }
        this.whens.add(when);
    }

    @Override
    String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder("CASE");
        for (When when : this.whens) {
            sql.append(" WHEN ").append(when.whenCondition.toSql(queryTables, dialect));
            sql.append(" THEN ").append(this.buildValue(when.thenValue));
        }
        if (this.elseValue != null) {
            sql.append(" ELSE ").append(this.buildValue(this.elseValue));
        }
        sql.append(" END");
        if (StringUtil.isNotBlank(this.alias)) {
            return "(" + sql + ") AS " + dialect.wrap(this.alias);
        }
        return sql.toString();
    }

    @Override
    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder("CASE");
        for (When when : this.whens) {
            sql.append(" WHEN ").append(when.whenCondition.toSql(queryTables, dialect));
            sql.append(" THEN ").append(this.buildValue(when.thenValue));
        }
        if (this.elseValue != null) {
            sql.append(" ELSE ").append(this.buildValue(this.elseValue));
        }
        sql.append(" END");
        return "(" + sql + ")";
    }

    @Override
    public QueryColumn as(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public <T> QueryColumn as(LambdaGetter<T> fn) {
        return this.as(LambdaUtil.getFieldName(fn));
    }

    private String buildValue(Object value) {
        if (value instanceof Number || value instanceof Boolean) {
            return String.valueOf(value);
        }
        if (value instanceof RawFragment) {
            return ((RawFragment)value).getContent();
        }
        if (value instanceof QueryColumn) {
            return ((QueryColumn)value).toConditionSql(null, DialectFactory.getDialect());
        }
        return "'" + value + "'";
    }

    @Override
    public Object[] getParamValues() {
        Object[] values = FlexConsts.EMPTY_ARRAY;
        for (When when : this.whens) {
            values = ArrayUtil.concat(values, WrapperUtil.getValues(when.whenCondition));
        }
        if (this.elseValue instanceof HasParamsColumn) {
            values = ArrayUtil.concat(values, ((HasParamsColumn)this.elseValue).getParamValues());
        }
        return values;
    }

    public static class Builder {
        private CaseQueryColumn caseQueryColumn = new CaseQueryColumn();

        public When when(QueryCondition condition) {
            return new When(this, condition);
        }

        public Builder else_(Object elseValue) {
            this.caseQueryColumn.elseValue = elseValue;
            return this;
        }

        public CaseQueryColumn end() {
            return this.caseQueryColumn;
        }
    }

    public static class When {
        private Builder builder;
        private QueryCondition whenCondition;
        private Object thenValue;

        public When(Builder builder, QueryCondition whenCondition) {
            this.builder = builder;
            this.whenCondition = whenCondition;
        }

        public Builder then(Object thenValue) {
            this.thenValue = thenValue;
            this.builder.caseQueryColumn.addWhen(this);
            return this.builder;
        }
    }
}

