/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.RawFragment;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class CaseSearchQueryColumn
extends QueryColumn
implements HasParamsColumn {
    private QueryColumn queryColumn;
    private List<When> whens;
    private Object elseValue;

    @Override
    String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder("CASE ");
        sql.append(this.queryColumn.toSelectSql(queryTables, dialect));
        for (When when : this.whens) {
            sql.append(" WHEN ").append(this.buildValue(when.searchValue)).append(" THEN ").append(this.buildValue(when.thenValue));
        }
        if (this.elseValue != null) {
            sql.append(" ELSE ").append(this.buildValue(this.elseValue));
        }
        sql.append(" END");
        if (StringUtil.isNotBlank(this.alias)) {
            return "(" + sql + ") AS " + dialect.wrap(this.alias);
        }
        return sql.toString();
    }

    @Override
    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder("CASE ");
        sql.append(this.queryColumn.toSelectSql(queryTables, dialect));
        for (When when : this.whens) {
            sql.append(" WHEN ").append(this.buildValue(when.searchValue)).append(" THEN ").append(this.buildValue(when.thenValue));
        }
        if (this.elseValue != null) {
            sql.append(" ELSE ").append(this.buildValue(this.elseValue));
        }
        sql.append(" END");
        return "(" + sql + ")";
    }

    private String buildValue(Object value) {
        if (value instanceof Number || value instanceof Boolean) {
            return String.valueOf(value);
        }
        if (value instanceof RawFragment) {
            return ((RawFragment)value).getContent();
        }
        if (value instanceof QueryColumn) {
            return ((QueryColumn)value).toConditionSql(null, DialectFactory.getDialect());
        }
        return "'" + value + "'";
    }

    void addWhen(When when) {
        if (this.whens == null) {
            this.whens = new ArrayList<When>();
        }
        this.whens.add(when);
    }

    @Override
    public QueryColumn as(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public <T> QueryColumn as(LambdaGetter<T> fn) {
        return this.as(LambdaUtil.getFieldName(fn));
    }

    @Override
    public Object[] getParamValues() {
        Object[] values = FlexConsts.EMPTY_ARRAY;
        if (this.elseValue instanceof HasParamsColumn) {
            values = ArrayUtil.concat(values, ((HasParamsColumn)this.elseValue).getParamValues());
        }
        return values;
    }

    public static class Builder {
        private CaseSearchQueryColumn caseQueryColumn = new CaseSearchQueryColumn();

        public Builder(QueryColumn queryColumn) {
            this.caseQueryColumn.queryColumn = queryColumn;
        }

        public When when(Object searchValue) {
            return new When(this, searchValue);
        }

        public Builder else_(Object elseValue) {
            this.caseQueryColumn.elseValue = elseValue;
            return this;
        }

        public CaseSearchQueryColumn end() {
            return this.caseQueryColumn;
        }
    }

    public static class When {
        private Builder builder;
        private Object searchValue;
        private Object thenValue;

        public When(Builder builder, Object searchValue) {
            this.builder = builder;
            this.searchValue = searchValue;
        }

        public Builder then(Object thenValue) {
            this.thenValue = thenValue;
            this.builder.caseQueryColumn.addWhen(this);
            return this.builder;
        }
    }
}

