/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class FunctionQueryColumn
extends QueryColumn
implements HasParamsColumn {
    protected String fnName;
    protected QueryColumn column;

    public FunctionQueryColumn(String fnName, String column) {
        SqlUtil.keepColumnSafely(fnName);
        SqlUtil.keepColumnSafely(column);
        this.fnName = fnName;
        this.column = new QueryColumn(column);
    }

    public FunctionQueryColumn(String fnName, QueryColumn column) {
        SqlUtil.keepColumnSafely(fnName);
        this.fnName = fnName;
        this.column = column;
    }

    public String getFnName() {
        return this.fnName;
    }

    public void setFnName(String fnName) {
        this.fnName = fnName;
    }

    public QueryColumn getColumn() {
        return this.column;
    }

    public void setColumn(QueryColumn column) {
        this.column = column;
    }

    @Override
    public Object[] getParamValues() {
        if (this.column instanceof HasParamsColumn) {
            return ((HasParamsColumn)((Object)this.column)).getParamValues();
        }
        return FlexConsts.EMPTY_ARRAY;
    }

    @Override
    public String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        String sql = this.column.toSelectSql(queryTables, dialect);
        return StringUtil.isBlank(sql) ? "" : this.fnName + "(" + sql + ")" + WrapperUtil.buildAsAlias(this.alias, dialect);
    }

    @Override
    public QueryColumn as(String alias) {
        SqlUtil.keepColumnSafely(alias);
        this.alias = alias;
        return this;
    }

    @Override
    public String toString() {
        return "FunctionQueryColumn{fnName='" + this.fnName + '\'' + ", column=" + this.column + '}';
    }
}

