/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class OperatorQueryCondition
extends QueryCondition {
    private final String operator;
    private final QueryCondition child;

    public OperatorQueryCondition(String operator, QueryCondition child) {
        this.operator = operator;
        this.child = child;
    }

    @Override
    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        String childSql;
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective() && StringUtil.isNotBlank(childSql = this.child.toSql(queryTables, dialect))) {
            QueryCondition effectiveBefore = this.getEffectiveBefore();
            if (effectiveBefore != null) {
                sql.append((Object)effectiveBefore.connector);
            }
            sql.append(this.operator).append("(").append(childSql).append(")");
        }
        if (this.next != null) {
            return sql + this.next.toSql(queryTables, dialect);
        }
        return sql.toString();
    }

    @Override
    public Object getValue() {
        return WrapperUtil.getValues(this.child);
    }

    @Override
    boolean containsTable(String ... tables) {
        return this.child != null && this.child.containsTable(tables);
    }
}

