/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.SqlConnector;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import java.util.Collection;
import java.util.function.Predicate;

public class QueryConditionBuilder {
    private QueryWrapper queryWrapper;
    private QueryColumn queryColumn;
    private SqlConnector connector;

    public QueryConditionBuilder(QueryWrapper queryWrapper, QueryColumn queryColumn, SqlConnector connector) {
        this.queryWrapper = queryWrapper;
        this.queryColumn = queryColumn;
        this.connector = connector;
    }

    public QueryWrapper eq(Object value) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.eq(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper eq(Object value, Predicate<T> when) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.eq(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper eq(LambdaGetter<T> value) {
        return this.eq(LambdaUtil.getQueryColumn(value));
    }

    public <T> QueryWrapper eq(LambdaGetter<T> value, Predicate<T> when) {
        return this.eq(LambdaUtil.getQueryColumn(value), when);
    }

    public QueryWrapper ne(Object value) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.ne(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper ne(Object value, Predicate<T> when) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.ne(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper ne(LambdaGetter<T> value) {
        return this.ne(LambdaUtil.getQueryColumn(value));
    }

    public <T> QueryWrapper ne(LambdaGetter<T> value, Predicate<T> when) {
        return this.ne(LambdaUtil.getQueryColumn(value), when);
    }

    public QueryWrapper like(Object value) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.like(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper like(Object value, Predicate<T> when) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.like(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public QueryWrapper likeLeft(Object value) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.likeLeft(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper likeLeft(Object value, Predicate<T> when) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.likeLeft(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public QueryWrapper likeRight(Object value) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.likeRight(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper likeRight(Object value, Predicate<T> when) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.likeRight(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public QueryWrapper gt(Object value) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.gt(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper gt(Object value, Predicate<T> when) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.gt(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper gt(LambdaGetter<T> value) {
        return this.gt(LambdaUtil.getQueryColumn(value));
    }

    public <T> QueryWrapper gt(LambdaGetter<T> value, Predicate<T> when) {
        return this.gt(LambdaUtil.getQueryColumn(value), when);
    }

    public QueryWrapper ge(Object value) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.ge(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper ge(Object value, Predicate<T> when) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.ge(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper ge(LambdaGetter<T> value) {
        return this.ge(LambdaUtil.getQueryColumn(value));
    }

    public <T> QueryWrapper ge(LambdaGetter<T> value, Predicate<T> when) {
        return this.ge(LambdaUtil.getQueryColumn(value), when);
    }

    public QueryWrapper lt(Object value) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.lt(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper lt(Object value, Predicate<T> when) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.lt(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper lt(LambdaGetter<T> value) {
        return this.lt(LambdaUtil.getQueryColumn(value));
    }

    public <T> QueryWrapper lt(LambdaGetter<T> value, Predicate<T> when) {
        return this.lt(LambdaUtil.getQueryColumn(value), when);
    }

    public QueryWrapper le(Object value) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.le(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper le(Object value, Predicate<T> when) {
        if (value != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.le(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper le(LambdaGetter<T> value) {
        return this.le(LambdaUtil.getQueryColumn(value));
    }

    public <T> QueryWrapper le(LambdaGetter<T> value, Predicate<T> when) {
        return this.le(LambdaUtil.getQueryColumn(value), when);
    }

    public QueryWrapper isNull() {
        this.queryWrapper.addWhereQueryCondition(this.queryColumn.isNull(), this.connector);
        return this.queryWrapper;
    }

    public <T> QueryWrapper isNull(Predicate<T> when) {
        this.queryWrapper.addWhereQueryCondition(this.queryColumn.isNull(when), this.connector);
        return this.queryWrapper;
    }

    public QueryWrapper isNotNull() {
        this.queryWrapper.addWhereQueryCondition(this.queryColumn.isNotNull(), this.connector);
        return this.queryWrapper;
    }

    public <T> QueryWrapper isNotNull(Predicate<T> when) {
        this.queryWrapper.addWhereQueryCondition(this.queryColumn.isNotNull(when), this.connector);
        return this.queryWrapper;
    }

    public QueryWrapper in(Object ... arrays) {
        if (arrays != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.in(arrays), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper in(Object[] arrays, Predicate<T> when) {
        if (arrays != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.in(arrays, when), this.connector);
        }
        return this.queryWrapper;
    }

    public QueryWrapper in(QueryWrapper queryWrapper) {
        if (queryWrapper != null) {
            queryWrapper.addWhereQueryCondition(this.queryColumn.in(queryWrapper), this.connector);
        }
        return queryWrapper;
    }

    public <T> QueryWrapper in(QueryWrapper queryWrapper, Predicate<T> when) {
        if (queryWrapper != null) {
            queryWrapper.addWhereQueryCondition(this.queryColumn.in(queryWrapper, when), this.connector);
        }
        return queryWrapper;
    }

    public QueryWrapper in(Collection<?> collection) {
        if (this.queryWrapper != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.in(collection), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper in(Collection<?> collection, Predicate<T> when) {
        if (this.queryWrapper != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.in(collection, when), this.connector);
        }
        return this.queryWrapper;
    }

    public QueryWrapper notIn(Object ... arrays) {
        if (this.queryWrapper != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.notIn(arrays), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper notIn(Object[] arrays, Predicate<T> when) {
        if (this.queryWrapper != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.notIn(arrays, when), this.connector);
        }
        return this.queryWrapper;
    }

    public QueryWrapper notIn(Collection<?> collection) {
        if (this.queryWrapper != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.notIn(collection), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper notIn(Collection<?> collection, Predicate<T> when) {
        if (this.queryWrapper != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.notIn(collection, when), this.connector);
        }
        return this.queryWrapper;
    }

    public QueryWrapper notIn(QueryWrapper queryWrapper) {
        if (queryWrapper != null) {
            queryWrapper.addWhereQueryCondition(this.queryColumn.notIn(queryWrapper), this.connector);
        }
        return queryWrapper;
    }

    public <T> QueryWrapper notIn(QueryWrapper queryWrapper, Predicate<T> when) {
        if (queryWrapper != null) {
            queryWrapper.addWhereQueryCondition(this.queryColumn.notIn(queryWrapper, when), this.connector);
        }
        return queryWrapper;
    }

    public QueryWrapper between(Object start, Object end) {
        if (this.queryWrapper != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.between(start, end), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper between(Object start, Object end, Predicate<T> when) {
        if (this.queryWrapper != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.between(start, end, when), this.connector);
        }
        return this.queryWrapper;
    }

    public QueryWrapper notBetween(Object start, Object end) {
        if (this.queryWrapper != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.notBetween(start, end), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> QueryWrapper notBetween(Object start, Object end, Predicate<T> when) {
        if (this.queryWrapper != null) {
            this.queryWrapper.addWhereQueryCondition(this.queryColumn.notBetween(start, end, when), this.connector);
        }
        return this.queryWrapper;
    }
}

