/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.util.StringUtil;
import java.io.Serializable;
import java.util.Objects;

public class QueryTable
implements Serializable {
    protected String schema;
    protected String name;
    protected String alias;

    public QueryTable() {
    }

    public QueryTable(TableDef tableDef) {
        this.name = tableDef.getTableName();
        this.schema = tableDef.getSchema();
    }

    public QueryTable(String name) {
        this.name = name;
    }

    public QueryTable(String schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    public QueryTable(String schema, String table, String alias) {
        this.schema = schema;
        this.name = table;
        this.alias = alias;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueryTable as(String alias) {
        this.alias = alias;
        return this;
    }

    boolean isSameTable(QueryTable table) {
        if (table == null) {
            return false;
        }
        if (StringUtil.isNotBlank(this.alias) && StringUtil.isNotBlank(table.alias) && Objects.equals(this.alias, table.alias)) {
            return false;
        }
        return Objects.equals(this.name, table.name);
    }

    Object[] getValueArray() {
        return FlexConsts.EMPTY_ARRAY;
    }

    public String toSql(IDialect dialect) {
        String sql = StringUtil.isNotBlank(this.schema) ? dialect.wrap(dialect.getRealSchema(this.schema)) + "." + dialect.wrap(dialect.getRealTable(this.name)) + WrapperUtil.buildAsAlias(this.alias, dialect) : dialect.wrap(dialect.getRealTable(this.name)) + WrapperUtil.buildAsAlias(this.alias, dialect);
        return sql;
    }

    public String toString() {
        return "QueryTable{schema='" + this.schema + '\'' + ", name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + '}';
    }
}

