/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class SelectQueryColumn
extends QueryColumn
implements HasParamsColumn {
    private QueryWrapper queryWrapper;

    public SelectQueryColumn(QueryWrapper queryWrapper) {
        this.queryWrapper = queryWrapper;
    }

    @Override
    public SelectQueryColumn as(String alias) {
        SqlUtil.keepColumnSafely(alias);
        this.alias = alias;
        return this;
    }

    QueryWrapper getQueryWrapper() {
        return this.queryWrapper;
    }

    @Override
    String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        String selectSql = dialect.forSelectByQuery(this.queryWrapper);
        if (StringUtil.isNotBlank(selectSql) && StringUtil.isNotBlank(this.alias)) {
            selectSql = "(" + selectSql + ") AS " + dialect.wrap(this.alias);
        }
        return selectSql;
    }

    @Override
    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        return super.toConditionSql(queryTables, dialect);
    }

    @Override
    public Object[] getParamValues() {
        return this.queryWrapper.getValueArray();
    }
}

