/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.table;

import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.SetListener;
import com.mybatisflex.annotation.UpdateListener;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.javassist.ModifyAttrsRecord;
import com.mybatisflex.core.mybatis.TypeHandlerObject;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.SelectQueryColumn;
import com.mybatisflex.core.query.SelectQueryTable;
import com.mybatisflex.core.query.UnionWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.table.BaseReflectorFactory;
import com.mybatisflex.core.table.ColumnInfo;
import com.mybatisflex.core.table.EntityMetaObject;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.tenant.TenantManager;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.util.MapUtil;

public class TableInfo {
    private String schema;
    private String tableName;
    private Class<?> entityClass;
    private boolean camelToUnderline = true;
    private String dataSource;
    private String logicDeleteColumn;
    private String versionColumn;
    private String tenantIdColumn;
    private Map<String, String> onInsertColumns;
    private Map<String, String> onUpdateColumns;
    private String[] largeColumns = new String[0];
    private String[] columns = new String[0];
    private String[] primaryKeys = new String[0];
    private String[] defaultColumns = new String[0];
    private String[] insertPrimaryKeys;
    private List<ColumnInfo> columnInfoList;
    private List<IdInfo> primaryKeyList;
    private final Map<String, ColumnInfo> columnInfoMapping = new HashMap<String, ColumnInfo>();
    private final Map<String, String> propertyColumnMapping = new HashMap<String, String>();
    private List<InsertListener> onInsertListeners;
    private List<UpdateListener> onUpdateListeners;
    private List<SetListener> onSetListeners;
    @Deprecated
    private Map<String, Class<?>> joinTypes;
    private Map<String, Class<?>> associationType;
    private Map<Field, Class<?>> collectionType;
    private final ReflectorFactory reflectorFactory = new BaseReflectorFactory(){

        public Reflector findForClass(Class<?> type) {
            return TableInfo.this.getReflector();
        }
    };
    private Reflector reflector;
    private static final String APPEND_CONDITIONS_FLAG = "appendConditions";
    private static final Map<Class<?>, List<InsertListener>> insertListenerCache = new ConcurrentHashMap();
    private static final Map<Class<?>, List<UpdateListener>> updateListenerCache = new ConcurrentHashMap();
    private static final Map<Class<?>, List<SetListener>> setListenerCache = new ConcurrentHashMap();

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getWrapSchemaAndTableName(IDialect dialect) {
        if (StringUtil.isNotBlank(this.schema)) {
            return dialect.wrap(dialect.getRealSchema(this.schema)) + "." + dialect.wrap(dialect.getRealTable(this.tableName));
        }
        return dialect.wrap(dialect.getRealTable(this.tableName));
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public boolean isCamelToUnderline() {
        return this.camelToUnderline;
    }

    public void setCamelToUnderline(boolean camelToUnderline) {
        this.camelToUnderline = camelToUnderline;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getLogicDeleteColumn() {
        return this.logicDeleteColumn;
    }

    public void setLogicDeleteColumn(String logicDeleteColumn) {
        this.logicDeleteColumn = logicDeleteColumn;
    }

    public String getVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn(String versionColumn) {
        this.versionColumn = versionColumn;
    }

    public String getTenantIdColumn() {
        return this.tenantIdColumn;
    }

    public void setTenantIdColumn(String tenantIdColumn) {
        this.tenantIdColumn = tenantIdColumn;
    }

    public Map<String, String> getOnInsertColumns() {
        return this.onInsertColumns;
    }

    public void setOnInsertColumns(Map<String, String> onInsertColumns) {
        this.onInsertColumns = onInsertColumns;
    }

    public Map<String, String> getOnUpdateColumns() {
        return this.onUpdateColumns;
    }

    public void setOnUpdateColumns(Map<String, String> onUpdateColumns) {
        this.onUpdateColumns = onUpdateColumns;
    }

    public String[] getLargeColumns() {
        return this.largeColumns;
    }

    public void setLargeColumns(String[] largeColumns) {
        this.largeColumns = largeColumns;
    }

    public String[] getDefaultColumns() {
        return this.defaultColumns;
    }

    public void setDefaultColumns(String[] defaultColumns) {
        this.defaultColumns = defaultColumns;
    }

    public String[] getInsertPrimaryKeys() {
        return this.insertPrimaryKeys;
    }

    public void setInsertPrimaryKeys(String[] insertPrimaryKeys) {
        this.insertPrimaryKeys = insertPrimaryKeys;
    }

    public Reflector getReflector() {
        return this.reflector;
    }

    public ReflectorFactory getReflectorFactory() {
        return this.reflectorFactory;
    }

    public void setReflector(Reflector reflector) {
        this.reflector = reflector;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public String[] getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(String[] primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public List<InsertListener> getOnInsertListeners() {
        return this.onInsertListeners;
    }

    public void setOnInsertListeners(List<InsertListener> onInsertListeners) {
        this.onInsertListeners = onInsertListeners;
    }

    public List<UpdateListener> getOnUpdateListeners() {
        return this.onUpdateListeners;
    }

    public void setOnUpdateListeners(List<UpdateListener> onUpdateListeners) {
        this.onUpdateListeners = onUpdateListeners;
    }

    public List<SetListener> getOnSetListeners() {
        return this.onSetListeners;
    }

    public void setOnSetListeners(List<SetListener> onSetListeners) {
        this.onSetListeners = onSetListeners;
    }

    public List<ColumnInfo> getColumnInfoList() {
        return this.columnInfoList;
    }

    public String getColumnByProperty(String property) {
        return this.propertyColumnMapping.get(property);
    }

    public Map<String, Class<?>> getJoinTypes() {
        return this.joinTypes;
    }

    public void setJoinTypes(Map<String, Class<?>> joinTypes) {
        this.joinTypes = joinTypes;
    }

    public void addJoinType(String fieldName, Class<?> clazz) {
        if (this.joinTypes == null) {
            this.joinTypes = new HashMap();
        }
        this.joinTypes.put(fieldName, clazz);
    }

    public Map<String, Class<?>> getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(Map<String, Class<?>> associationType) {
        this.associationType = associationType;
    }

    public void addAssociationType(String fieldName, Class<?> clazz) {
        if (this.associationType == null) {
            this.associationType = new HashMap();
        }
        this.associationType.put(fieldName, clazz);
    }

    public Map<Field, Class<?>> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Map<Field, Class<?>> collectionType) {
        this.collectionType = collectionType;
    }

    public void addCollectionType(Field field, Class<?> genericClass) {
        if (this.collectionType == null) {
            this.collectionType = new HashMap();
        }
        this.collectionType.put(field, genericClass);
    }

    void setColumnInfoList(List<ColumnInfo> columnInfoList) {
        this.columnInfoList = columnInfoList;
        this.columns = new String[columnInfoList.size()];
        for (int i = 0; i < columnInfoList.size(); ++i) {
            ColumnInfo columnInfo = columnInfoList.get(i);
            this.columns[i] = columnInfo.getColumn();
            this.columnInfoMapping.put(columnInfo.column, columnInfo);
            this.propertyColumnMapping.put(columnInfo.property, columnInfo.column);
        }
    }

    public List<IdInfo> getPrimaryKeyList() {
        return this.primaryKeyList;
    }

    void setPrimaryKeyList(List<IdInfo> primaryKeyList) {
        this.primaryKeyList = primaryKeyList;
        this.primaryKeys = new String[primaryKeyList.size()];
        ArrayList<String> insertIdFields = new ArrayList<String>();
        for (int i = 0; i < primaryKeyList.size(); ++i) {
            IdInfo idInfo = primaryKeyList.get(i);
            this.primaryKeys[i] = idInfo.getColumn();
            if (idInfo.getKeyType() != KeyType.Auto && idInfo.getBefore() != null && idInfo.getBefore().booleanValue()) {
                insertIdFields.add(idInfo.getColumn());
            }
            this.columnInfoMapping.put(idInfo.column, idInfo);
            this.propertyColumnMapping.put(idInfo.property, idInfo.column);
        }
        this.insertPrimaryKeys = insertIdFields.toArray(new String[0]);
    }

    public String[] obtainInsertColumns(Object entity, boolean ignoreNulls) {
        if (!ignoreNulls) {
            return ArrayUtil.concat(this.insertPrimaryKeys, this.columns);
        }
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        ArrayList<String> retColumns = new ArrayList<String>();
        for (String insertColumn : this.columns) {
            if (this.onInsertColumns != null && this.onInsertColumns.containsKey(insertColumn)) {
                retColumns.add(insertColumn);
                continue;
            }
            Object value = this.buildColumnSqlArg(metaObject, insertColumn);
            if (value == null) continue;
            retColumns.add(insertColumn);
        }
        return ArrayUtil.concat(this.insertPrimaryKeys, retColumns.toArray(new String[0]));
    }

    public Object[] buildInsertSqlArgs(Object entity, boolean ignoreNulls) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        String[] insertColumns = this.obtainInsertColumns(entity, ignoreNulls);
        ArrayList<Object> values = new ArrayList<Object>(insertColumns.length);
        for (String insertColumn : insertColumns) {
            if (this.onInsertColumns != null && this.onInsertColumns.containsKey(insertColumn)) continue;
            Object value = this.buildColumnSqlArg(metaObject, insertColumn);
            if (ignoreNulls && value == null) continue;
            values.add(value);
        }
        return values.toArray();
    }

    public Set<String> obtainUpdateColumns(Object entity, boolean ignoreNulls, boolean includePrimary) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        if (entity instanceof ModifyAttrsRecord) {
            Set<String> properties = ((ModifyAttrsRecord)entity).obtainModifyAttrs();
            if (properties.isEmpty()) {
                return Collections.emptySet();
            }
            for (String property : properties) {
                String column = this.propertyColumnMapping.get(property);
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn) || !includePrimary && ArrayUtil.contains(this.primaryKeys, column)) continue;
                columns.add(column);
            }
        } else {
            for (String column : this.columns) {
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn)) continue;
                Object value = this.buildColumnSqlArg(metaObject, column);
                if (ignoreNulls && value == null) continue;
                columns.add(column);
            }
        }
        return columns;
    }

    public Object[] buildUpdateSqlArgs(Object entity, boolean ignoreNulls, boolean includePrimary) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        ArrayList<Object> values = new ArrayList<Object>();
        if (entity instanceof ModifyAttrsRecord) {
            Set<String> properties = ((ModifyAttrsRecord)entity).obtainModifyAttrs();
            if (properties.isEmpty()) {
                return values.toArray();
            }
            for (String property : properties) {
                String column = this.propertyColumnMapping.get(property);
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn) || !includePrimary && ArrayUtil.contains(this.primaryKeys, column)) continue;
                Object value = this.buildColumnSqlArg(metaObject, column);
                values.add(value);
            }
        } else {
            for (String column : this.columns) {
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn)) continue;
                Object value = this.buildColumnSqlArg(metaObject, column);
                if (ignoreNulls && value == null) continue;
                values.add(value);
            }
        }
        return values.toArray();
    }

    public Object[] buildPkSqlArgs(Object entity) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        Object[] values = new Object[this.primaryKeys.length];
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            values[i] = this.buildColumnSqlArg(metaObject, this.primaryKeys[i]);
        }
        return values;
    }

    public Object[] buildTenantIdArgs() {
        if (StringUtil.isBlank(this.tenantIdColumn)) {
            return null;
        }
        return TenantManager.getTenantIds();
    }

    public void appendConditions(Object entity, QueryWrapper queryWrapper) {
        List<UnionWrapper> unions;
        List<QueryWrapper> childSelects;
        Object[] objectArray;
        List<QueryTable> queryTables;
        Object appendConditions = CPI.getContext(queryWrapper, APPEND_CONDITIONS_FLAG);
        if (Boolean.TRUE.equals(appendConditions)) {
            return;
        }
        CPI.putContext(queryWrapper, APPEND_CONDITIONS_FLAG, Boolean.TRUE);
        List<QueryColumn> selectColumns = CPI.getSelectColumns(queryWrapper);
        if (selectColumns != null && !selectColumns.isEmpty()) {
            for (QueryColumn queryColumn : selectColumns) {
                if (!(queryColumn instanceof SelectQueryColumn)) continue;
                QueryWrapper selectColumnQueryWrapper = CPI.getQueryWrapper((SelectQueryColumn)queryColumn);
                this.doAppendConditions(entity, selectColumnQueryWrapper);
            }
        }
        if ((queryTables = CPI.getQueryTables(queryWrapper)) != null && !queryTables.isEmpty()) {
            for (QueryTable queryTable : queryTables) {
                if (!(queryTable instanceof SelectQueryTable)) continue;
                QueryWrapper selectQueryWrapper = ((SelectQueryTable)queryTable).getQueryWrapper();
                this.doAppendConditions(entity, selectQueryWrapper);
            }
        }
        if (StringUtil.isNotBlank(this.versionColumn) && entity != null) {
            Object object = this.buildColumnSqlArg(entity, this.versionColumn);
            if (object == null) {
                throw FlexExceptions.wrap("The version value of entity[%s] must not be null.", entity);
            }
            queryWrapper.and(QueryCondition.create(this.schema, this.tableName, this.versionColumn, "=", object));
        }
        if (StringUtil.isNotBlank(this.logicDeleteColumn)) {
            queryWrapper.and(QueryCondition.create(this.schema, this.tableName, this.logicDeleteColumn, "=", FlexGlobalConfig.getDefaultConfig().getNormalValueOfLogicDelete()));
        }
        if (ArrayUtil.isNotEmpty(objectArray = this.buildTenantIdArgs())) {
            if (objectArray.length == 1) {
                queryWrapper.and(QueryCondition.create(this.schema, this.tableName, this.tenantIdColumn, "=", objectArray[0]));
            } else {
                queryWrapper.and(QueryCondition.create(this.schema, this.tableName, this.tenantIdColumn, "IN", objectArray));
            }
        }
        if (CollectionUtil.isNotEmpty(childSelects = CPI.getChildSelect(queryWrapper))) {
            for (QueryWrapper childQueryWrapper : childSelects) {
                this.doAppendConditions(entity, childQueryWrapper);
            }
        }
        if (CollectionUtil.isNotEmpty(unions = CPI.getUnions(queryWrapper))) {
            for (UnionWrapper union : unions) {
                QueryWrapper unionQueryWrapper = union.getQueryWrapper();
                this.doAppendConditions(entity, unionQueryWrapper);
            }
        }
    }

    private void doAppendConditions(Object entity, QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables != null && !queryTables.isEmpty()) {
            for (QueryTable queryTable : queryTables) {
                TableInfo tableInfo = TableInfoFactory.ofTableName(queryTable.getName());
                if (tableInfo == null) continue;
                tableInfo.appendConditions(entity, queryWrapper);
            }
        }
    }

    public String getKeyProperties() {
        StringJoiner joiner = new StringJoiner(",");
        for (IdInfo value : this.primaryKeyList) {
            joiner.add("$$entity." + value.getProperty());
        }
        return joiner.toString();
    }

    public String getKeyColumns() {
        StringJoiner joiner = new StringJoiner(",");
        for (IdInfo value : this.primaryKeyList) {
            joiner.add(value.getColumn());
        }
        return joiner.toString();
    }

    public List<QueryColumn> getDefaultQueryColumn() {
        return Arrays.stream(this.defaultColumns).map(name -> new QueryColumn(this.schema, this.getTableName(), (String)name)).collect(Collectors.toList());
    }

    @Deprecated
    public ResultMap buildResultMap(Configuration configuration) {
        ResultMapping mapping;
        String resultMapId = this.entityClass.getName();
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (ColumnInfo columnInfo : this.columnInfoList) {
            mapping = new ResultMapping.Builder(configuration, columnInfo.property, columnInfo.column, columnInfo.propertyType).jdbcType(columnInfo.getJdbcType()).typeHandler(columnInfo.buildTypeHandler()).build();
            resultMappings.add(mapping);
            if (Objects.equals(columnInfo.getColumn(), columnInfo.getProperty())) continue;
            ResultMapping propertyMapping = new ResultMapping.Builder(configuration, columnInfo.property, columnInfo.property, columnInfo.propertyType).jdbcType(columnInfo.getJdbcType()).typeHandler(columnInfo.buildTypeHandler()).build();
            resultMappings.add(propertyMapping);
        }
        for (IdInfo idInfo : this.primaryKeyList) {
            mapping = new ResultMapping.Builder(configuration, idInfo.property, idInfo.column, idInfo.propertyType).flags(CollectionUtil.newArrayList(ResultFlag.ID)).jdbcType(idInfo.getJdbcType()).typeHandler(idInfo.buildTypeHandler()).build();
            resultMappings.add(mapping);
        }
        if (this.joinTypes != null && !this.joinTypes.isEmpty()) {
            this.joinTypes.forEach((fieldName, fieldType) -> {
                TableInfo joinTableInfo = TableInfoFactory.ofEntityClass(fieldType);
                List<ColumnInfo> joinTableInfoColumnInfoList = joinTableInfo.getColumnInfoList();
                for (ColumnInfo joinColumnInfo : joinTableInfoColumnInfoList) {
                    if (!TableInfo.existColumn(resultMappings, joinColumnInfo.column)) {
                        ResultMapping mapping = new ResultMapping.Builder(configuration, fieldName + "." + joinColumnInfo.property, joinColumnInfo.column, joinColumnInfo.propertyType).jdbcType(joinColumnInfo.jdbcType).typeHandler(joinColumnInfo.buildTypeHandler()).build();
                        resultMappings.add(mapping);
                    }
                    if (TableInfo.existColumn(resultMappings, joinColumnInfo.property) || Objects.equals(joinColumnInfo.column, joinColumnInfo.property)) continue;
                    ResultMapping propertyMapping = new ResultMapping.Builder(configuration, fieldName + "." + joinColumnInfo.property, joinColumnInfo.property, joinColumnInfo.propertyType).jdbcType(joinColumnInfo.jdbcType).typeHandler(joinColumnInfo.buildTypeHandler()).build();
                    resultMappings.add(propertyMapping);
                }
            });
        }
        return new ResultMap.Builder(configuration, resultMapId, this.entityClass, resultMappings).build();
    }

    public List<ResultMap> buildResultMapList(Configuration configuration) {
        ResultMapping mapping;
        String resultMapId = this.entityClass.getName();
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (ColumnInfo columnInfo : this.columnInfoList) {
            mapping = new ResultMapping.Builder(configuration, columnInfo.property, columnInfo.column, columnInfo.propertyType).jdbcType(columnInfo.getJdbcType()).typeHandler(columnInfo.buildTypeHandler()).build();
            resultMappings.add(mapping);
            if (Objects.equals(columnInfo.getColumn(), columnInfo.getProperty())) continue;
            ResultMapping propertyMapping = new ResultMapping.Builder(configuration, columnInfo.property, columnInfo.property, columnInfo.propertyType).jdbcType(columnInfo.getJdbcType()).typeHandler(columnInfo.buildTypeHandler()).build();
            resultMappings.add(propertyMapping);
        }
        for (IdInfo idInfo : this.primaryKeyList) {
            mapping = new ResultMapping.Builder(configuration, idInfo.property, idInfo.column, idInfo.propertyType).flags(CollectionUtil.newArrayList(ResultFlag.ID)).jdbcType(idInfo.getJdbcType()).typeHandler(idInfo.buildTypeHandler()).build();
            resultMappings.add(mapping);
        }
        if (this.associationType != null) {
            this.associationType.forEach((fieldName, fieldType) -> {
                TableInfo tableInfo = TableInfoFactory.ofEntityClass(fieldType);
                List<ResultMap> resultMapList = tableInfo.buildResultMapList(configuration);
                Optional<ResultMap> nestedResultMap = resultMapList.stream().filter(e -> fieldType.getName().equals(e.getId())).findFirst();
                nestedResultMap.ifPresent(resultMap -> resultMappings.add(new ResultMapping.Builder(configuration, fieldName).javaType(fieldType).nestedResultMapId(resultMap.getId()).build()));
                resultMaps.addAll(resultMapList);
            });
        }
        if (this.collectionType != null) {
            this.collectionType.forEach((field, genericClass) -> {
                TableInfo tableInfo = TableInfoFactory.ofEntityClass(genericClass);
                List<ResultMap> resultMapList = tableInfo.buildResultMapList(configuration);
                Optional<ResultMap> nestedResultMap = resultMapList.stream().filter(e -> genericClass.getName().equals(e.getId())).findFirst();
                nestedResultMap.ifPresent(resultMap -> resultMappings.add(new ResultMapping.Builder(configuration, field.getName()).javaType(field.getType()).nestedResultMapId(resultMap.getId()).build()));
                resultMaps.addAll(resultMapList);
            });
        }
        resultMaps.add(new ResultMap.Builder(configuration, resultMapId, this.entityClass, resultMappings).build());
        return resultMaps;
    }

    private static boolean existColumn(List<ResultMapping> resultMappings, String name) {
        for (ResultMapping resultMapping : resultMappings) {
            if (!resultMapping.getColumn().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private Object buildColumnSqlArg(MetaObject metaObject, String column) {
        TypeHandler typeHandler;
        ColumnInfo columnInfo = this.columnInfoMapping.get(column);
        Object value = this.getPropertyValue(metaObject, columnInfo.property);
        if (value != null && (typeHandler = columnInfo.buildTypeHandler()) != null) {
            return new TypeHandlerObject(typeHandler, value, columnInfo.getJdbcType());
        }
        return value;
    }

    public Object buildColumnSqlArg(Object entityObject, String column) {
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        return this.buildColumnSqlArg(metaObject, column);
    }

    private Object getPropertyValue(MetaObject metaObject, String property) {
        if (property != null && metaObject.hasGetter(property)) {
            return metaObject.getValue(property);
        }
        return null;
    }

    public <T> T newInstanceByRow(Row row, int index) {
        Object instance = ClassUtil.newInstance(this.entityClass);
        MetaObject metaObject = EntityMetaObject.forObject(instance, this.reflectorFactory);
        Set rowKeys = row.keySet();
        this.columnInfoMapping.forEach((column, columnInfo) -> {
            if (index <= 0) {
                for (String rowKey : rowKeys) {
                    if (!column.equalsIgnoreCase(rowKey)) continue;
                    this.setInstancePropertyValue(row, instance, metaObject, (ColumnInfo)columnInfo, rowKey);
                }
            } else {
                for (int i = index; i >= 0; --i) {
                    String newColumn = i <= 0 ? column : column + "$" + i;
                    boolean fillValue = false;
                    for (String rowKey : rowKeys) {
                        if (!newColumn.equalsIgnoreCase(rowKey)) continue;
                        this.setInstancePropertyValue(row, instance, metaObject, (ColumnInfo)columnInfo, rowKey);
                        fillValue = true;
                        break;
                    }
                    if (!fillValue) {
                        continue;
                    }
                    break;
                }
            }
        });
        return (T)instance;
    }

    private void setInstancePropertyValue(Row row, Object instance, MetaObject metaObject, ColumnInfo columnInfo, String rowKey) {
        Object rowValue = row.get(rowKey);
        TypeHandler typeHandler = columnInfo.buildTypeHandler();
        if (typeHandler != null) {
            try {
                rowValue = typeHandler.getResult(this.getResultSet(rowValue), 0);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (rowValue != null && !metaObject.getSetterType(columnInfo.property).isAssignableFrom(rowValue.getClass())) {
            rowValue = ConvertUtil.convert(rowValue, metaObject.getSetterType(columnInfo.property), true);
        }
        rowValue = this.invokeOnSetListener(instance, columnInfo.getProperty(), rowValue);
        metaObject.setValue(columnInfo.property, rowValue);
    }

    private ResultSet getResultSet(Object value) {
        return (ResultSet)Proxy.newProxyInstance(TableInfo.class.getClassLoader(), new Class[]{ResultSet.class}, (proxy, method, args) -> value);
    }

    public void initVersionValueIfNecessary(Object entityObject) {
        if (StringUtil.isBlank(this.versionColumn)) {
            return;
        }
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        Object columnValue = this.getPropertyValue(metaObject, this.columnInfoMapping.get((Object)this.versionColumn).property);
        if (columnValue == null) {
            String name = this.columnInfoMapping.get((Object)this.versionColumn).property;
            Class clazz = metaObject.getSetterType(name);
            metaObject.setValue(name, ConvertUtil.convert(0L, clazz));
        }
    }

    public void initTenantIdIfNecessary(Object entityObject) {
        if (StringUtil.isBlank(this.tenantIdColumn)) {
            return;
        }
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        Object[] tenantIds = TenantManager.getTenantIds();
        if (tenantIds == null || tenantIds.length == 0) {
            return;
        }
        Object tenantId = tenantIds[0];
        if (tenantId != null) {
            String property = this.columnInfoMapping.get((Object)this.tenantIdColumn).property;
            Class setterType = metaObject.getSetterType(property);
            metaObject.setValue(property, ConvertUtil.convert(tenantId, setterType));
        }
    }

    public void initLogicDeleteValueIfNecessary(Object entityObject) {
        if (StringUtil.isBlank(this.logicDeleteColumn)) {
            return;
        }
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        Object columnValue = this.getPropertyValue(metaObject, this.columnInfoMapping.get((Object)this.logicDeleteColumn).property);
        if (columnValue == null) {
            String property = this.columnInfoMapping.get((Object)this.logicDeleteColumn).property;
            Class setterType = metaObject.getSetterType(property);
            Object normalValueOfLogicDelete = FlexGlobalConfig.getDefaultConfig().getNormalValueOfLogicDelete();
            metaObject.setValue(property, ConvertUtil.convert(normalValueOfLogicDelete, setterType));
        }
    }

    public void invokeOnInsertListener(Object entity) {
        List listeners = (List)MapUtil.computeIfAbsent(insertListenerCache, this.entityClass, aClass -> {
            List<InsertListener> globalListeners = FlexGlobalConfig.getDefaultConfig().getSupportedInsertListener(this.entityClass, CollectionUtil.isNotEmpty(this.onInsertListeners));
            List<InsertListener> allListeners = CollectionUtil.merge(this.onInsertListeners, globalListeners);
            Collections.sort(allListeners);
            return allListeners;
        });
        listeners.forEach(insertListener -> insertListener.onInsert(entity));
    }

    public void invokeOnUpdateListener(Object entity) {
        List listeners = (List)MapUtil.computeIfAbsent(updateListenerCache, this.entityClass, aClass -> {
            List<UpdateListener> globalListeners = FlexGlobalConfig.getDefaultConfig().getSupportedUpdateListener(this.entityClass, CollectionUtil.isNotEmpty(this.onUpdateListeners));
            List<UpdateListener> allListeners = CollectionUtil.merge(this.onUpdateListeners, globalListeners);
            Collections.sort(allListeners);
            return allListeners;
        });
        listeners.forEach(insertListener -> insertListener.onUpdate(entity));
    }

    public Object invokeOnSetListener(Object entity, String property, Object value) {
        List listeners = (List)MapUtil.computeIfAbsent(setListenerCache, this.entityClass, aClass -> {
            List<SetListener> globalListeners = FlexGlobalConfig.getDefaultConfig().getSupportedSetListener(this.entityClass, CollectionUtil.isNotEmpty(this.onSetListeners));
            List<SetListener> allListeners = CollectionUtil.merge(this.onSetListeners, globalListeners);
            Collections.sort(allListeners);
            return allListeners;
        });
        for (SetListener setListener : listeners) {
            value = setListener.onSet(entity, property, value);
        }
        return value;
    }

    public QueryColumn getQueryColumnByProperty(String property) {
        return new QueryColumn(this.schema, this.tableName, this.propertyColumnMapping.get(property));
    }
}

