/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.field.FieldQuery;
import com.mybatisflex.core.field.FieldQueryBuilder;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.FieldWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.ibatis.exceptions.TooManyResultsException;

public class MapperUtil {
    private MapperUtil() {
    }

    public static <R> void queryFields(BaseMapper<?> mapper, List<R> list, Consumer<FieldQueryBuilder<R>>[] consumers) {
        if (CollectionUtil.isEmpty(list) || ArrayUtil.isEmpty(consumers) || consumers[0] == null) {
            return;
        }
        list.forEach(entity -> {
            for (Consumer consumer : consumers) {
                Collection<Object> value;
                FieldQueryBuilder<Object> fieldQueryBuilder = new FieldQueryBuilder<Object>(entity);
                consumer.accept(fieldQueryBuilder);
                FieldQuery fieldQuery = fieldQueryBuilder.build();
                QueryWrapper childQuery = fieldQuery.getQueryWrapper();
                FieldWrapper fieldWrapper = FieldWrapper.of(entity.getClass(), fieldQuery.getField());
                Class<?> fieldType = fieldWrapper.getFieldType();
                Class<?> mappingType = fieldWrapper.getMappingType();
                if (Collection.class.isAssignableFrom(fieldType)) {
                    value = mapper.selectListByQueryAs(childQuery, mappingType);
                    if (!fieldType.isAssignableFrom(value.getClass())) {
                        fieldType = MapperUtil.getWrapType(fieldType);
                        Collection newValue = (Collection)ClassUtil.newInstance(fieldType);
                        newValue.addAll((Collection)value);
                        value = newValue;
                    }
                } else if (fieldType.isArray()) {
                    value = mapper.selectListByQueryAs(childQuery, mappingType);
                    value = value.toArray();
                } else {
                    value = mapper.selectOneByQueryAs(childQuery, mappingType);
                }
                fieldWrapper.set(value, entity);
            }
        });
    }

    private static Class<?> getWrapType(Class<?> type) {
        if (List.class.isAssignableFrom(type)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return HashSet.class;
        }
        throw new IllegalStateException("Field query can not support type: " + type.getName());
    }

    public static <T> T getSelectOneResult(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        if (size == 1) {
            return list.get(0);
        }
        throw new TooManyResultsException("Expected one result (or null) to be returned by selectOne(), but found: " + size);
    }
}

