/*
 *  Copyright (c) 2022-2023, Mybatis-Flex (fuhai999@gmail.com).
 *  <p>
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  <p>
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  <p>
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.mybatisflex.core.constant;

/**
 * 支持的 SQL 函数名。
 *
 * @author 王帅
 * @since 2023-07-03
 */
public class FuncName {

    public static final String ABS = "ABS";
    public static final String ACOS = "ACOS";
    public static final String ADDDATE = "ADDDATE";
    public static final String ADDTIME = "ADDTIME";
    public static final String ASCII = "ASCII";
    public static final String ASIN = "ASIN";
    public static final String ATAN = "ATAN";
    public static final String AVG = "AVG";
    public static final String BIN = "BIN";
    public static final String CEIL = "CEIL";
    public static final String CEILING = "CEILING";
    public static final String CHARSET = "CHARSET";
    public static final String CHAR_LENGTH = "CHAR_LENGTH";
    public static final String COLLATION = "COLLATION";
    public static final String CONCAT = "CONCAT";
    public static final String CONCAT_WS = "CONCAT_WS";
    public static final String CONNECTION_ID = "CONNECTION_ID";
    public static final String CONV = "CONV";
    public static final String CONVERT = "CONVERT";
    public static final String COS = "COS";
    public static final String COT = "COT";
    public static final String COUNT = "COUNT";
    public static final String CURDATE = "CURDATE";
    public static final String CURRENT_DATE = "CURRENT_DATE";
    public static final String CURRENT_TIME = "CURRENT_TIME";
    public static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    public static final String CURTIME = "CURTIME";
    public static final String DATABASE = "DATABASE";
    public static final String DATEDIFF = "DATEDIFF";
    public static final String DATE_FORMAT = "DATE_FORMAT";
    public static final String DAY = "DAY";
    public static final String DAYNAME = "DAYNAME";
    public static final String DAYOFMONTH = "DAYOFMONTH";
    public static final String DAYOFWEEK = "DAYOFWEEK";
    public static final String DAYOFYEAR = "DAYOFYEAR";
    public static final String DECODE = "DECODE";
    public static final String DEGREES = "DEGREES";
    public static final String ELT = "ELT";
    public static final String ENCODE = "ENCODE";
    public static final String EXP = "EXP";
    public static final String FIELD = "FIELD";
    public static final String FIND_IN_SET = "FIND_IN_SET";
    public static final String FLOOR = "FLOOR";
    public static final String FORMAT = "FORMAT";
    public static final String FROM_DAYS = "FROM_DAYS";
    public static final String FROM_UNIXTIME = "FROM_UNIXTIME";
    public static final String GET_FORMAT = "GET_FORMAT";
    public static final String GET_LOCT = "GET_LOCT";
    public static final String HEX = "HEX";
    public static final String HOUR = "HOUR";
    public static final String INET_ATON = "INET_ATON";
    public static final String INET_NTOA = "INET_NTOA";
    public static final String INSERT = "INSERT";
    public static final String INSTR = "INSTR";
    public static final String IS_FREE_LOCK = "IS_FREE_LOCK";
    public static final String LAST_INSERT_ID = "LAST_INSERT_ID";
    public static final String LEFT = "LEFT";
    public static final String LENGTH = "LENGTH";
    public static final String LOCALTIME = "LOCALTIME";
    public static final String LOCALTIMESTAMP = "LOCALTIMESTAMP";
    public static final String LOG = "LOG";
    public static final String LOG10 = "LOG10";
    public static final String LOWER = "LOWER";
    public static final String LPAD = "LPAD";
    public static final String LTRIM = "LTRIM";
    public static final String MAX = "MAX";
    public static final String MD5 = "MD5";
    public static final String MIN = "MIN";
    public static final String MINUTE = "MINUTE";
    public static final String MOD = "MOD";
    public static final String MONTH = "MONTH";
    public static final String MONTHNAME = "MONTHNAME";
    public static final String NOW = "NOW";
    public static final String OCT = "OCT";
    public static final String PASSWORD = "PASSWORD";
    public static final String PI = "PI";
    public static final String POW = "POW";
    public static final String POWER = "POWER";
    public static final String QUARTER = "QUARTER";
    public static final String RADIANS = "RADIANS";
    public static final String RAND = "RAND";
    public static final String RELEASE_LOCK = "RELEASE_LOCK";
    public static final String REPEAT = "REPEAT";
    public static final String REPLACE = "REPLACE";
    public static final String REVERSE = "REVERSE";
    public static final String RIGHT = "RIGHT";
    public static final String ROUND = "ROUND";
    public static final String RPAD = "RPAD";
    public static final String RTRIM = "RTRIM";
    public static final String SCHEMA = "SCHEMA";
    public static final String SECOND = "SECOND";
    public static final String SEC_TO_TIME = "SEC_TO_TIME";
    public static final String SIGN = "SIGN";
    public static final String SIN = "SIN";
    public static final String SPACE = "SPACE";
    public static final String SQRT = "SQRT";
    public static final String STRCMP = "STRCMP";
    public static final String SUBDATE = "SUBDATE";
    public static final String SUBSTRING = "SUBSTRING";
    public static final String SUBTIME = "SUBTIME";
    public static final String SUM = "SUM";
    public static final String SYSDATE = "SYSDATE";
    public static final String TAN = "TAN";
    public static final String TIME_FORMAT = "TIME_FORMAT";
    public static final String TIME_TO_SEC = "TIME_TO_SEC";
    public static final String TO_DAYS = "TO_DAYS";
    public static final String TRIM = "TRIM";
    public static final String TRUNCATE = "TRUNCATE";
    public static final String UNIX_TIMESTAMP = "UNIX_TIMESTAMP";
    public static final String UPPER = "UPPER";
    public static final String USER = "USER";
    public static final String UTC_DATE = "UTC_DATE";
    public static final String UTC_TIME = "UTC_TIME";
    public static final String VERSION = "VERSION";
    public static final String WEEK = "WEEK";
    public static final String WEEKDAY = "WEEKDAY";
    public static final String WEEKOFYEAR = "WEEKOFYEAR";
    public static final String YEAR = "YEAR";

    private FuncName() {
    }

}