/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.datasource;

import java.util.function.Supplier;

public class DataSourceKey {
    private static final ThreadLocal<String> keyThreadLocal = new ThreadLocal();

    private DataSourceKey() {
    }

    public static void use(String dataSourceKey) {
        keyThreadLocal.set(dataSourceKey);
    }

    public static <T> T use(String dataSourceKey, Supplier<T> supplier) {
        try {
            DataSourceKey.use(dataSourceKey);
            T t = supplier.get();
            return t;
        }
        finally {
            DataSourceKey.clear();
        }
    }

    public static void use(String dataSourceKey, Runnable runnable) {
        try {
            DataSourceKey.use(dataSourceKey);
            runnable.run();
        }
        finally {
            DataSourceKey.clear();
        }
    }

    public static void clear() {
        keyThreadLocal.remove();
    }

    public static String get() {
        return keyThreadLocal.get();
    }
}

