/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.Reflectors;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.reflection.Reflector;

public class FieldWrapper {
    public static Map<Class<?>, Map<String, FieldWrapper>> cache = new ConcurrentHashMap();
    private Class<?> fieldType;
    private Class<?> mappingType;
    private Class<?> keyType;
    private Method getterMethod;
    private Method setterMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldWrapper of(Class<?> clazz, String fieldName) {
        FieldWrapper fieldWrapper;
        Map<String, FieldWrapper> wrapperMap = cache.get(clazz);
        if (wrapperMap == null) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                if (wrapperMap == null) {
                    wrapperMap = new ConcurrentHashMap<String, FieldWrapper>();
                    cache.put(clazz, wrapperMap);
                }
            }
        }
        if ((fieldWrapper = wrapperMap.get(fieldName)) == null) {
            Class<?> clazz3 = clazz;
            synchronized (clazz3) {
                fieldWrapper = wrapperMap.get(fieldName);
                if (fieldWrapper == null) {
                    Field findField = ClassUtil.getFirstField(clazz, field -> field.getName().equals(fieldName));
                    if (findField == null) {
                        throw new IllegalStateException("Can not find field \"" + fieldName + "\" in class: " + clazz);
                    }
                    String setterName = "set" + StringUtil.firstCharToUpperCase(fieldName);
                    Method setter = ClassUtil.getFirstMethod(clazz, method -> method.getParameterCount() == 1 && Modifier.isPublic(method.getModifiers()) && method.getName().equals(setterName));
                    if (setter == null) {
                        throw new IllegalStateException("Can not find method \"set" + StringUtil.firstCharToUpperCase(fieldName) + "\" in class: " + clazz);
                    }
                    fieldWrapper = new FieldWrapper();
                    fieldWrapper.fieldType = findField.getType();
                    FieldWrapper.initMappingTypeAndKeyType(clazz, findField, fieldWrapper);
                    fieldWrapper.setterMethod = setter;
                    String[] getterNames = new String[]{"get" + StringUtil.firstCharToUpperCase(fieldName), "is" + StringUtil.firstCharToUpperCase(fieldName)};
                    fieldWrapper.getterMethod = ClassUtil.getFirstMethod(clazz, method -> method.getParameterCount() == 0 && Modifier.isPublic(method.getModifiers()) && ArrayUtil.contains(getterNames, method.getName()));
                    wrapperMap.put(fieldName, fieldWrapper);
                }
            }
        }
        return fieldWrapper;
    }

    private static void initMappingTypeAndKeyType(Class<?> clazz, Field field, FieldWrapper fieldWrapper) {
        Reflector reflector = Reflectors.of(clazz);
        Class fieldType = reflector.getGetterType(field.getName());
        if (Collection.class.isAssignableFrom(fieldType)) {
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                Type actualTypeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                fieldWrapper.mappingType = (Class)actualTypeArgument;
            }
        } else if (Map.class.isAssignableFrom(fieldType)) {
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                fieldWrapper.keyType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                fieldWrapper.mappingType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[1];
            }
        } else {
            fieldWrapper.mappingType = fieldType;
        }
    }

    public void set(Object value, Object to) {
        try {
            this.setterMethod.invoke(to, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object get(Object target) {
        try {
            return this.getterMethod.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public Class<?> getMappingType() {
        return this.mappingType;
    }

    public Class<?> getKeyType() {
        return this.keyType;
    }
}

