/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Pattern;

public class StringUtil {
    private StringUtil() {
    }

    public static String firstCharToLowerCase(String string) {
        char firstChar = string.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = string.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return string;
    }

    public static String firstCharToUpperCase(String string) {
        char firstChar = string.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = string.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return string;
    }

    public static String camelToUnderline(String string) {
        if (StringUtil.isBlank(string)) {
            return "";
        }
        int strLen = string.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String underlineToCamel(String string) {
        if (StringUtil.isBlank(string)) {
            return "";
        }
        String temp = string.toLowerCase();
        int strLen = temp.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = temp.charAt(i);
            if (c == '_') {
                if (++i >= strLen) continue;
                sb.append(Character.toUpperCase(temp.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(String ... strings) {
        if (strings == null || strings.length == 0) {
            throw new IllegalArgumentException("args is empty.");
        }
        for (String str : strings) {
            if (!StringUtil.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean areNotBlank(String ... strings) {
        return !StringUtil.isAnyBlank(new String[0]);
    }

    public static boolean isNumeric(String str) {
        if (StringUtil.isBlank(str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithAny(String str, String ... prefixes) {
        if (StringUtil.isBlank(str) || prefixes == null || prefixes.length == 0) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!str.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithAny(String str, String ... suffixes) {
        if (StringUtil.isBlank(str) || suffixes == null || suffixes.length == 0) {
            return false;
        }
        for (String suffix : suffixes) {
            if (!str.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String trimOrNull(String string) {
        return string != null ? string.trim() : null;
    }

    public static boolean matches(String regex, String input) {
        if (null == regex || null == input) {
            return false;
        }
        return Pattern.matches(regex, input);
    }

    public static String join(String delimiter, CharSequence ... elements) {
        if (ArrayUtil.isEmpty(elements)) {
            return "";
        }
        if (elements.length == 1) {
            return String.valueOf(elements[0]);
        }
        return String.join((CharSequence)delimiter, elements);
    }

    public static String join(String delimiter, Collection<? extends CharSequence> elements) {
        if (CollectionUtil.isEmpty(elements)) {
            return "";
        }
        if (elements.size() == 1) {
            return String.valueOf(elements.iterator().next());
        }
        return String.join((CharSequence)delimiter, elements);
    }

    public static <T> String join(String delimiter, Collection<T> objs, Function<T, String> function) {
        if (CollectionUtil.isEmpty(objs)) {
            return "";
        }
        if (objs.size() == 1) {
            T next = objs.iterator().next();
            return String.valueOf(function.apply(next));
        }
        CharSequence[] strings = new String[objs.size()];
        int index = 0;
        for (T obj : objs) {
            strings[index++] = function.apply(obj);
        }
        return String.join((CharSequence)delimiter, strings);
    }

    public static String buildSchemaWithTable(String schema, String tableName) {
        return StringUtil.isNotBlank(schema) ? schema + "." + tableName : tableName;
    }

    public static String[] getSchemaAndTableName(String tableNameWithSchema) {
        String[] stringArray;
        int index = tableNameWithSchema.indexOf(".");
        if (index <= 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = null;
            stringArray = stringArray2;
            stringArray2[1] = tableNameWithSchema.trim();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = tableNameWithSchema.substring(0, index).trim();
            stringArray = stringArray3;
            stringArray3[1] = tableNameWithSchema.substring(index + 1).trim();
        }
        return stringArray;
    }

    public static String tryTrim(String string) {
        return string != null ? string.trim() : null;
    }
}

