/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.keygen;

import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.core.keygen.IMultiKeyGenerator;
import com.mybatisflex.core.keygen.RowCustomKeyGenerator;
import com.mybatisflex.core.keygen.RowJdbc3KeyGenerator;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowCPI;
import com.mybatisflex.core.row.RowKey;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;

public class RowKeyGenerator
implements KeyGenerator,
IMultiKeyGenerator {
    private static final KeyGenerator[] NO_KEY_GENERATORS = new KeyGenerator[0];
    private final MappedStatement ms;
    private KeyGenerator[] keyGenerators;
    private List<String> autoKeyGeneratorNames;

    public RowKeyGenerator(MappedStatement methodMappedStatement) {
        this.ms = methodMappedStatement;
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        Row row = (Row)((Map)parameter).get("$$row");
        for (KeyGenerator keyGenerator : this.keyGenerators = this.buildRowKeyGenerators(RowCPI.obtainsPrimaryKeys(row))) {
            keyGenerator.processBefore(executor, ms, stmt, parameter);
        }
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        for (KeyGenerator keyGenerator : this.keyGenerators) {
            keyGenerator.processAfter(executor, ms, stmt, parameter);
        }
    }

    private KeyGenerator[] buildRowKeyGenerators(RowKey[] rowKeys) {
        if (ArrayUtil.isEmpty(rowKeys)) {
            return NO_KEY_GENERATORS;
        }
        KeyGenerator[] keyGenerators = new KeyGenerator[rowKeys.length];
        for (int i = 0; i < rowKeys.length; ++i) {
            KeyGenerator keyGenerator;
            keyGenerators[i] = keyGenerator = this.createByRowKey(rowKeys[i]);
        }
        return keyGenerators;
    }

    private KeyGenerator createByRowKey(RowKey rowKey) {
        if (rowKey == null || rowKey.getKeyType() == KeyType.None) {
            return NoKeyGenerator.INSTANCE;
        }
        if (rowKey.getKeyType() == KeyType.Auto) {
            if (this.autoKeyGeneratorNames == null) {
                this.autoKeyGeneratorNames = new ArrayList<String>();
            }
            this.autoKeyGeneratorNames.add(rowKey.getKeyColumn());
            return new RowJdbc3KeyGenerator(rowKey.getKeyColumn());
        }
        if (rowKey.getKeyType() == KeyType.Generator) {
            return new RowCustomKeyGenerator(rowKey);
        }
        String selectId = "row.!selectKey";
        String sequence = rowKey.getValue();
        SqlSource sqlSource = this.ms.getLang().createSqlSource(this.ms.getConfiguration(), sequence.trim(), Object.class);
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(this.ms.getConfiguration(), selectId, sqlSource, SqlCommandType.SELECT).resource(this.ms.getResource()).fetchSize(null).timeout(null).statementType(StatementType.PREPARED).keyGenerator((KeyGenerator)NoKeyGenerator.INSTANCE).keyProperty("$$row." + rowKey.getKeyColumn()).keyColumn(rowKey.getKeyColumn()).databaseId(this.ms.getDatabaseId()).lang(this.ms.getLang()).resultOrdered(false).resultSets(null).resultMaps(new ArrayList()).resultSetType(null).flushCacheRequired(false).useCache(false).cache(this.ms.getCache());
        MappedStatement keyMappedStatement = msBuilder.build();
        this.ms.getConfiguration().addMappedStatement(keyMappedStatement);
        return new SelectKeyGenerator(keyMappedStatement, rowKey.isBefore());
    }

    @Override
    public boolean hasGeneratedKeys() {
        return CollectionUtil.isNotEmpty(this.autoKeyGeneratorNames);
    }

    @Override
    public String[] getKeyColumnNames() {
        return this.autoKeyGeneratorNames.toArray(new String[0]);
    }
}

