/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.util.MapUtil;

public class Mappers {
    private static final Map<Class<?>, Class<?>> ENTITY_MAPPER_MAP = new ConcurrentHashMap();
    private static final Map<Class<?>, Object> MAPPER_OBJECTS = new ConcurrentHashMap();

    static void addMapping(Class<?> entityClass, Class<?> mapperClass) {
        ENTITY_MAPPER_MAP.put(entityClass, mapperClass);
    }

    public static <Entity> BaseMapper<Entity> ofEntityClass(Class<Entity> entityClass) {
        Class<?> mapperClass = ENTITY_MAPPER_MAP.get(entityClass);
        if (mapperClass == null) {
            throw FlexExceptions.wrap("Can not find MapperClass by entity: " + entityClass.getName(), new Object[0]);
        }
        return (BaseMapper)Mappers.ofMapperClass(mapperClass);
    }

    public static <Mapper> Mapper ofMapperClass(Class<Mapper> mapperClass) {
        Object mapperObject = MapUtil.computeIfAbsent(MAPPER_OBJECTS, mapperClass, clazz -> Proxy.newProxyInstance(mapperClass.getClassLoader(), new Class[]{mapperClass}, (InvocationHandler)new MapperHandler(mapperClass)));
        return (Mapper)mapperObject;
    }

    static class MapperHandler
    implements InvocationHandler {
        private Class<?> mapperClass;
        private final SqlSessionFactory sqlSessionFactory = FlexGlobalConfig.getDefaultConfig().getSqlSessionFactory();
        private final ExecutorType executorType = FlexGlobalConfig.getDefaultConfig().getConfiguration().getDefaultExecutorType();

        public MapperHandler(Class<?> mapperClass) {
            this.mapperClass = mapperClass;
        }

        private SqlSession openSession() {
            return this.sqlSessionFactory.openSession(this.executorType, true);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try (SqlSession sqlSession = this.openSession();){
                Object mapper = sqlSession.getMapper(this.mapperClass);
                Object object = method.invoke(mapper, args);
                return object;
            }
        }
    }
}

