/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.WithDetail;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class WithItem
implements CloneSupport<WithItem> {
    private String name;
    private List<String> params;
    private WithDetail withDetail;

    public WithItem() {
    }

    public WithItem(String name, List<String> params) {
        this.name = name;
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getParams() {
        return this.params;
    }

    public void setParams(List<String> params) {
        this.params = params;
    }

    public WithDetail getWithDetail() {
        return this.withDetail;
    }

    public void setWithDetail(WithDetail withDetail) {
        this.withDetail = withDetail;
    }

    public String toSql(IDialect dialect) {
        StringBuilder sql = new StringBuilder(this.name);
        if (CollectionUtil.isNotEmpty(this.params)) {
            sql.append("(").append(StringUtil.join(", ", this.params)).append(")");
        }
        sql.append(" AS ").append("(");
        sql.append(this.withDetail.toSql(dialect));
        return sql.append(")").toString();
    }

    public Object[] getParamValues() {
        return this.withDetail.getParamValues();
    }

    @Override
    public WithItem clone() {
        try {
            WithItem clone = (WithItem)super.clone();
            clone.withDetail = ObjectUtil.clone(this.withDetail);
            clone.params = CollectionUtil.newArrayList(this.params);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

