/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.update;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.mybatis.Mappers;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryWrapperAdapter;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.update.UpdateWrapper;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.UpdateEntity;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class UpdateChain<T>
extends QueryWrapperAdapter<UpdateChain<T>> {
    private final BaseMapper<T> baseMapper;
    private final T entity;
    private final UpdateWrapper entityWrapper;

    public static <T> UpdateChain<T> of(Class<T> entityClass) {
        BaseMapper<T> baseMapper = Mappers.ofEntityClass(entityClass);
        return new UpdateChain<T>(baseMapper);
    }

    public static <T> UpdateChain<T> of(T entityObject) {
        Class<?> entityClass = ClassUtil.getUsefulClass(entityObject.getClass());
        BaseMapper<?> baseMapper = Mappers.ofEntityClass(entityClass);
        return new UpdateChain(baseMapper, entityObject);
    }

    public UpdateChain(BaseMapper<T> baseMapper) {
        this.baseMapper = baseMapper;
        this.entity = this.createEntity(ClassUtil.getUsefulClass(baseMapper.getClass()));
        this.entityWrapper = (UpdateWrapper)this.entity;
    }

    public UpdateChain(BaseMapper<T> baseMapper, T entityObject) {
        this.baseMapper = baseMapper;
        entityObject = UpdateWrapper.of(entityObject);
        this.entity = entityObject;
        this.entityWrapper = (UpdateWrapper)entityObject;
    }

    private T createEntity(Class<?> mapperClass) {
        Type type = mapperClass.getGenericInterfaces()[0];
        if (type instanceof ParameterizedType) {
            Class modelClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            return UpdateEntity.of(modelClass);
        }
        throw FlexExceptions.wrap("Can not get entity class from mapper: " + mapperClass.getName(), new Object[0]);
    }

    public static <E> UpdateChain<E> create(BaseMapper<E> baseMapper) {
        return new UpdateChain<E>(baseMapper);
    }

    public UpdateChain<T> set(String property, Object value) {
        this.entityWrapper.set(property, value);
        return this;
    }

    public UpdateChain<T> set(LambdaGetter<T> getter, Object value) {
        this.entityWrapper.set(getter, value);
        return this;
    }

    public UpdateChain<T> set(QueryColumn queryColumn, Object value) {
        this.entityWrapper.set(queryColumn, value);
        return this;
    }

    public UpdateChain<T> setRaw(String property, Object value) {
        this.entityWrapper.setRaw(property, value);
        return this;
    }

    public UpdateChain<T> setRaw(LambdaGetter<T> getter, Object value) {
        this.entityWrapper.setRaw(getter, value);
        return this;
    }

    public UpdateChain<T> setRaw(QueryColumn queryColumn, Object value) {
        this.entityWrapper.set(queryColumn, value);
        return this;
    }

    public boolean remove() {
        return SqlUtil.toBool(this.baseMapper.deleteByQuery(this));
    }

    public boolean update() {
        return SqlUtil.toBool(this.baseMapper.updateByQuery(this.entity, this));
    }

    @Override
    public String toSQL() {
        TableInfo tableInfo = TableInfoFactory.ofMapperClass(this.baseMapper.getClass());
        CPI.setFromIfNecessary(this, tableInfo.getSchema(), tableInfo.getTableName());
        String sql = DialectFactory.getDialect().forUpdateEntityByQuery(tableInfo, this.entity, true, this);
        Object[] values = tableInfo.buildUpdateSqlArgs(this.entity, true, true);
        values = ArrayUtil.concat(values, CPI.getValueArray(this));
        return SqlUtil.replaceSqlParams(sql, values);
    }
}

