/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.activerecord;

import com.mybatisflex.core.activerecord.MapperModel;
import com.mybatisflex.core.activerecord.query.FieldsQuery;
import com.mybatisflex.core.activerecord.query.QueryModel;
import com.mybatisflex.core.activerecord.query.RelationsQuery;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.util.SqlUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;

public abstract class Model<T extends Model<T>>
extends QueryModel<T>
implements MapperModel<T>,
Serializable {
    public boolean remove() {
        return SqlUtil.toBool(this.baseMapper().deleteByQuery(this.queryWrapper()));
    }

    public boolean update() {
        return this.update(true);
    }

    public boolean update(boolean ignoreNulls) {
        return SqlUtil.toBool(this.baseMapper().updateByQuery(this, ignoreNulls, this.queryWrapper()));
    }

    public long count() {
        return this.baseMapper().selectCountByQuery(this.queryWrapper());
    }

    public boolean exists() {
        return SqlUtil.toBool(this.count());
    }

    public T one() {
        return (T)((Model)this.baseMapper().selectOneByQuery(this.queryWrapper()));
    }

    public <R> R oneAs(Class<R> asType) {
        return this.baseMapper().selectOneByQueryAs(this.queryWrapper(), asType);
    }

    public Optional<T> oneOpt() {
        return Optional.ofNullable(this.one());
    }

    public <R> Optional<R> oneAsOpt(Class<R> asType) {
        return Optional.ofNullable(this.oneAs(asType));
    }

    public Object obj() {
        return this.baseMapper().selectObjectByQuery(this.queryWrapper());
    }

    public <R> R objAs(Class<R> asType) {
        return this.baseMapper().selectObjectByQueryAs(this.queryWrapper(), asType);
    }

    public Optional<Object> objOpt() {
        return Optional.ofNullable(this.obj());
    }

    public <R> Optional<R> objAsOpt(Class<R> asType) {
        return Optional.ofNullable(this.objAs(asType));
    }

    public List<Object> objList() {
        return this.baseMapper().selectObjectListByQuery(this.queryWrapper());
    }

    public <R> List<R> objListAs(Class<R> asType) {
        return this.baseMapper().selectObjectListByQueryAs(this.queryWrapper(), asType);
    }

    public List<T> list() {
        return this.baseMapper().selectListByQuery(this.queryWrapper());
    }

    public <R> List<R> listAs(Class<R> asType) {
        return this.baseMapper().selectListByQueryAs(this.queryWrapper(), asType);
    }

    public Page<T> page(Page<T> page) {
        return this.baseMapper().paginate(page, this.queryWrapper());
    }

    public <R> Page<R> pageAs(Page<R> page, Class<R> asType) {
        return this.baseMapper().paginateAs(page, this.queryWrapper(), asType);
    }

    public FieldsQuery<T> withFields() {
        return new FieldsQuery(this);
    }

    public RelationsQuery<T> withRelations() {
        return new RelationsQuery(this);
    }
}

