/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.activerecord.query;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.core.activerecord.query.JoinBuilder;
import com.mybatisflex.core.activerecord.query.OrderByBuilder;
import com.mybatisflex.core.activerecord.query.WhereBuilder;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.SqlConnector;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;

public abstract class QueryModel<T extends QueryModel<T>> {
    @Column(ignore=true)
    private QueryWrapper queryWrapper;

    protected QueryWrapper queryWrapper() {
        if (this.queryWrapper == null) {
            TableInfo tableInfo = TableInfoFactory.ofEntityClass(this.getClass());
            QueryTable queryTable = new QueryTable();
            queryTable.setSchema(tableInfo.getSchema());
            queryTable.setName(tableInfo.getTableName());
            this.queryWrapper = QueryWrapper.create().from(queryTable);
        }
        return this.queryWrapper;
    }

    public T as(String alias) {
        this.queryWrapper().as(alias);
        return (T)this;
    }

    public T select() {
        return (T)this;
    }

    public T select(String ... columns) {
        this.queryWrapper().select(columns);
        return (T)this;
    }

    public T select(QueryColumn ... queryColumns) {
        this.queryWrapper().select(queryColumns);
        return (T)this;
    }

    public <E> T select(LambdaGetter<E> ... columns) {
        this.queryWrapper().select(columns);
        return (T)this;
    }

    public T select(QueryColumn[] ... queryColumns) {
        this.queryWrapper().select(queryColumns);
        return (T)this;
    }

    public T where(QueryCondition queryCondition) {
        this.queryWrapper().where(queryCondition);
        return (T)this;
    }

    public T where(String sql) {
        this.queryWrapper().where(sql);
        return (T)this;
    }

    public T where(String sql, Object ... params) {
        this.queryWrapper().where(sql, params);
        return (T)this;
    }

    public <E> WhereBuilder<T> where(LambdaGetter<E> column) {
        return new WhereBuilder<QueryModel>(this, LambdaUtil.getQueryColumn(column), SqlConnector.AND);
    }

    public T and(QueryCondition queryCondition) {
        this.queryWrapper().and(queryCondition);
        return (T)this;
    }

    public T and(String sql) {
        this.queryWrapper().and(sql);
        return (T)this;
    }

    public T and(String sql, Object ... params) {
        this.queryWrapper().and(sql, params);
        return (T)this;
    }

    public <E> WhereBuilder<T> and(LambdaGetter<E> column) {
        return new WhereBuilder<QueryModel>(this, LambdaUtil.getQueryColumn(column), SqlConnector.AND);
    }

    public T or(QueryCondition queryCondition) {
        this.queryWrapper().or(queryCondition);
        return (T)this;
    }

    public T or(String sql) {
        this.queryWrapper().or(sql);
        return (T)this;
    }

    public T or(String sql, Object ... params) {
        this.queryWrapper().or(sql, params);
        return (T)this;
    }

    public <E> WhereBuilder<T> or(LambdaGetter<E> column) {
        return new WhereBuilder<QueryModel>(this, LambdaUtil.getQueryColumn(column), SqlConnector.OR);
    }

    public JoinBuilder<T> leftJoin(String table) {
        return this.joins(" LEFT JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> leftJoin(String table, boolean when) {
        return this.joins(" LEFT JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> leftJoin(Class<?> entityClass) {
        return this.joins(" LEFT JOIN ", entityClass, true);
    }

    public JoinBuilder<T> leftJoin(Class<?> entityClass, boolean when) {
        return this.joins(" LEFT JOIN ", entityClass, when);
    }

    public JoinBuilder<T> leftJoin(TableDef table) {
        return this.joins(" LEFT JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> leftJoin(TableDef table, boolean when) {
        return this.joins(" LEFT JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> leftJoin(QueryWrapper table) {
        return this.joins(" LEFT JOIN ", table, true);
    }

    public JoinBuilder<T> leftJoin(QueryWrapper table, boolean when) {
        return this.joins(" LEFT JOIN ", table, when);
    }

    public JoinBuilder<T> rightJoin(String table) {
        return this.joins(" RIGHT JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> rightJoin(String table, boolean when) {
        return this.joins(" RIGHT JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> rightJoin(Class<?> entityClass) {
        return this.joins(" RIGHT JOIN ", entityClass, true);
    }

    public JoinBuilder<T> rightJoin(Class<?> entityClass, boolean when) {
        return this.joins(" RIGHT JOIN ", entityClass, when);
    }

    public JoinBuilder<T> rightJoin(TableDef table) {
        return this.joins(" RIGHT JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> rightJoin(TableDef table, boolean when) {
        return this.joins(" RIGHT JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> rightJoin(QueryWrapper table) {
        return this.joins(" RIGHT JOIN ", table, true);
    }

    public JoinBuilder<T> rightJoin(QueryWrapper table, boolean when) {
        return this.joins(" RIGHT JOIN ", table, when);
    }

    public JoinBuilder<T> innerJoin(String table) {
        return this.joins(" INNER JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> innerJoin(String table, boolean when) {
        return this.joins(" INNER JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> innerJoin(Class<?> entityClass) {
        return this.joins(" INNER JOIN ", entityClass, true);
    }

    public JoinBuilder<T> innerJoin(Class<?> entityClass, boolean when) {
        return this.joins(" INNER JOIN ", entityClass, when);
    }

    public JoinBuilder<T> innerJoin(TableDef table) {
        return this.innerJoin(table, true);
    }

    public JoinBuilder<T> innerJoin(TableDef table, boolean when) {
        return this.joins(" INNER JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> innerJoin(QueryWrapper table) {
        return this.joins(" INNER JOIN ", table, true);
    }

    public JoinBuilder<T> innerJoin(QueryWrapper table, boolean when) {
        return this.joins(" INNER JOIN ", table, when);
    }

    public JoinBuilder<T> fullJoin(String table) {
        return this.joins(" FULL JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> fullJoin(String table, boolean when) {
        return this.joins(" FULL JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> fullJoin(Class<?> entityClass) {
        return this.joins(" FULL JOIN ", entityClass, true);
    }

    public JoinBuilder<T> fullJoin(Class<?> entityClass, boolean when) {
        return this.joins(" FULL JOIN ", entityClass, when);
    }

    public JoinBuilder<T> fullJoin(TableDef table) {
        return this.joins(" FULL JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> fullJoin(TableDef table, boolean when) {
        return this.joins(" FULL JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> fullJoin(QueryWrapper table) {
        return this.joins(" FULL JOIN ", table, true);
    }

    public JoinBuilder<T> fullJoin(QueryWrapper table, boolean when) {
        return this.joins(" FULL JOIN ", table, when);
    }

    public JoinBuilder<T> crossJoin(String table) {
        return this.joins(" CROSS JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> crossJoin(String table, boolean when) {
        return this.joins(" CROSS JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> crossJoin(Class<?> entityClass) {
        return this.joins(" CROSS JOIN ", entityClass, true);
    }

    public JoinBuilder<T> crossJoin(Class<?> entityClass, boolean when) {
        return this.joins(" CROSS JOIN ", entityClass, when);
    }

    public JoinBuilder<T> crossJoin(TableDef table) {
        return this.joins(" CROSS JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> crossJoin(TableDef table, boolean when) {
        return this.joins(" CROSS JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> crossJoin(QueryWrapper table) {
        return this.joins(" CROSS JOIN ", table, true);
    }

    public JoinBuilder<T> crossJoin(QueryWrapper table, boolean when) {
        return this.joins(" CROSS JOIN ", table, when);
    }

    public JoinBuilder<T> join(String table) {
        return this.joins(" JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> join(String table, boolean when) {
        return this.joins(" JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> join(Class<?> entityClass) {
        return this.joins(" JOIN ", entityClass, true);
    }

    public JoinBuilder<T> join(Class<?> entityClass, boolean when) {
        return this.joins(" JOIN ", entityClass, when);
    }

    public JoinBuilder<T> join(TableDef table) {
        return this.joins(" JOIN ", new QueryTable(table), true);
    }

    public JoinBuilder<T> join(TableDef table, boolean when) {
        return this.joins(" JOIN ", new QueryTable(table), when);
    }

    public JoinBuilder<T> join(QueryWrapper table) {
        return this.joins(" JOIN ", table, true);
    }

    public JoinBuilder<T> join(QueryWrapper table, boolean when) {
        return this.joins(" JOIN ", table, when);
    }

    public T groupBy(String ... names) {
        this.queryWrapper().groupBy(names);
        return (T)this;
    }

    public T groupBy(QueryColumn ... columns) {
        this.queryWrapper().groupBy(columns);
        return (T)this;
    }

    public <E> T groupBy(LambdaGetter<E> ... columns) {
        this.queryWrapper().groupBy(columns);
        return (T)this;
    }

    public T having(QueryCondition queryCondition) {
        this.queryWrapper().having(queryCondition);
        return (T)this;
    }

    public T orderBy(QueryOrderBy ... orderBys) {
        this.queryWrapper().orderBy(orderBys);
        return (T)this;
    }

    public T orderBy(String ... orderBys) {
        this.queryWrapper().orderBy(orderBys);
        return (T)this;
    }

    public <E> OrderByBuilder<T> orderBy(LambdaGetter<E> column) {
        return new OrderByBuilder<QueryModel>(this, column);
    }

    public T limit(Number rows) {
        this.queryWrapper().limit(rows);
        return (T)this;
    }

    public T offset(Number offset) {
        this.queryWrapper().offset(offset);
        return (T)this;
    }

    public T limit(Number offset, Number rows) {
        this.queryWrapper().limit(offset, rows);
        return (T)this;
    }

    protected JoinBuilder<T> joins(String type, QueryTable table, boolean when) {
        Join join = new Join(type, table, when);
        CPI.addJoin(this.queryWrapper(), join);
        return new JoinBuilder<QueryModel>(this, join);
    }

    protected JoinBuilder<T> joins(String type, Class<?> entityClass, boolean when) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        QueryTable queryTable = new QueryTable(tableInfo.getSchema(), tableInfo.getTableName());
        return this.joins(type, queryTable, when);
    }

    protected JoinBuilder<T> joins(String type, QueryWrapper queryWrapper, boolean when) {
        Join join = new Join(type, queryWrapper, when);
        CPI.addJoin(this.queryWrapper(), join);
        return new JoinBuilder<QueryModel>(this, join);
    }
}

