/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.SqlConnector;
import com.mybatisflex.core.query.UnionWrapper;
import com.mybatisflex.core.query.With;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BaseQueryWrapper<T extends BaseQueryWrapper<T>>
implements CloneSupport<T> {
    protected With with;
    protected List<QueryTable> queryTables;
    protected String dataSource;
    protected String hint;
    protected List<QueryColumn> selectColumns;
    protected List<Join> joins;
    protected List<QueryTable> joinTables;
    protected QueryCondition whereQueryCondition;
    protected List<QueryColumn> groupByColumns;
    protected QueryCondition havingQueryCondition;
    protected List<QueryOrderBy> orderBys;
    protected List<UnionWrapper> unions;
    protected Long limitOffset;
    protected Long limitRows;
    protected List<String> endFragments;
    protected Map<String, Object> context;

    public void clear() {
        this.with = null;
        this.queryTables = null;
        this.dataSource = null;
        this.hint = null;
        this.selectColumns = null;
        this.joins = null;
        this.joinTables = null;
        this.whereQueryCondition = null;
        this.groupByColumns = null;
        this.havingQueryCondition = null;
        this.orderBys = null;
        this.unions = null;
        this.limitOffset = null;
        this.limitRows = null;
        this.endFragments = null;
        this.context = null;
    }

    protected T addSelectColumn(QueryColumn queryColumn) {
        if (this.selectColumns == null) {
            this.selectColumns = new ArrayList<QueryColumn>();
        }
        this.selectColumns.add(queryColumn);
        return (T)this;
    }

    protected T addJoin(Join join) {
        if (this.joins == null) {
            this.joins = new ArrayList<Join>();
        }
        this.joins.add(join);
        return (T)this;
    }

    protected T setWhereQueryCondition(QueryCondition queryCondition) {
        if (this.whereQueryCondition != null) {
            queryCondition.connect(this.whereQueryCondition, SqlConnector.AND);
        }
        this.whereQueryCondition = queryCondition;
        return (T)this;
    }

    protected T addWhereQueryCondition(QueryCondition queryCondition, SqlConnector connector) {
        if (queryCondition != null) {
            if (this.whereQueryCondition == null) {
                this.whereQueryCondition = queryCondition;
            } else {
                this.whereQueryCondition.connect(queryCondition, connector);
            }
        }
        return (T)this;
    }

    protected T addGroupByColumns(QueryColumn queryColumn) {
        if (this.groupByColumns == null) {
            this.groupByColumns = new ArrayList<QueryColumn>();
        }
        this.groupByColumns.add(queryColumn);
        return (T)this;
    }

    protected T addHavingQueryCondition(QueryCondition queryCondition, SqlConnector connector) {
        if (this.havingQueryCondition == null) {
            this.havingQueryCondition = queryCondition;
        } else {
            this.havingQueryCondition.connect(queryCondition, connector);
        }
        return (T)this;
    }

    protected T addOrderBy(QueryOrderBy queryOrderBy) {
        if (this.orderBys == null) {
            this.orderBys = new LinkedList<QueryOrderBy>();
        }
        this.orderBys.add(queryOrderBy);
        return (T)this;
    }

    protected void addJoinTable(QueryTable queryTable) {
        if (this.joinTables == null) {
            this.joinTables = new ArrayList<QueryTable>();
        }
        this.joinTables.add(queryTable);
    }

    protected void addEndFragment(String fragment) {
        if (this.endFragments == null) {
            this.endFragments = new ArrayList<String>();
        }
        this.endFragments.add(fragment);
    }

    protected List<QueryTable> getQueryTables() {
        return this.queryTables;
    }

    protected void setQueryTables(List<QueryTable> queryTables) {
        this.queryTables = queryTables;
    }

    protected String getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    protected String getHint() {
        return this.hint;
    }

    protected void setHint(String hint) {
        this.hint = hint;
    }

    protected List<QueryColumn> getSelectColumns() {
        return this.selectColumns;
    }

    protected void setSelectColumns(List<QueryColumn> selectColumns) {
        this.selectColumns = selectColumns;
    }

    protected List<Join> getJoins() {
        return this.joins;
    }

    protected void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    protected List<QueryTable> getJoinTables() {
        return this.joinTables;
    }

    protected void setJoinTables(List<QueryTable> joinTables) {
        this.joinTables = joinTables;
    }

    protected QueryCondition getWhereQueryCondition() {
        return this.whereQueryCondition;
    }

    protected List<QueryColumn> getGroupByColumns() {
        return this.groupByColumns;
    }

    protected void setGroupByColumns(List<QueryColumn> groupByColumns) {
        this.groupByColumns = groupByColumns;
    }

    protected QueryCondition getHavingQueryCondition() {
        return this.havingQueryCondition;
    }

    protected void setHavingQueryCondition(QueryCondition havingQueryCondition) {
        this.havingQueryCondition = havingQueryCondition;
    }

    protected List<QueryOrderBy> getOrderBys() {
        return this.orderBys;
    }

    protected void setOrderBys(List<QueryOrderBy> orderBys) {
        this.orderBys = orderBys;
    }

    protected List<UnionWrapper> getUnions() {
        return this.unions;
    }

    protected void setUnions(List<UnionWrapper> unions) {
        this.unions = unions;
    }

    protected Long getLimitOffset() {
        return this.limitOffset;
    }

    protected void setLimitOffset(Long limitOffset) {
        this.limitOffset = limitOffset;
    }

    protected Long getLimitRows() {
        return this.limitRows;
    }

    protected void setLimitRows(Long limitRows) {
        this.limitRows = limitRows;
    }

    protected List<String> getEndFragments() {
        return this.endFragments;
    }

    protected void setEndFragments(List<String> endFragments) {
        this.endFragments = endFragments;
    }

    protected Map<String, Object> getContext() {
        return this.context;
    }

    protected void setContext(Map<String, Object> context) {
        this.context = context;
    }

    protected void putContext(String key, Object value) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        this.context.put(key, value);
    }

    protected <R> R getContext(String key) {
        return (R)(this.context == null ? null : this.context.get(key));
    }

    @Override
    public T clone() {
        try {
            BaseQueryWrapper clone = (BaseQueryWrapper)super.clone();
            clone.with = ObjectUtil.clone(this.with);
            clone.queryTables = CollectionUtil.cloneArrayList(this.queryTables);
            clone.selectColumns = CollectionUtil.cloneArrayList(this.selectColumns);
            clone.joins = CollectionUtil.cloneArrayList(this.joins);
            clone.joinTables = CollectionUtil.cloneArrayList(this.joinTables);
            clone.whereQueryCondition = ObjectUtil.clone(this.whereQueryCondition);
            clone.groupByColumns = CollectionUtil.cloneArrayList(this.groupByColumns);
            clone.havingQueryCondition = ObjectUtil.clone(this.havingQueryCondition);
            clone.orderBys = CollectionUtil.cloneArrayList(this.orderBys);
            clone.unions = CollectionUtil.cloneArrayList(this.unions);
            if (this.endFragments != null) {
                clone.endFragments = CollectionUtil.newArrayList(this.endFragments);
            }
            if (this.context != null) {
                clone.context = CollectionUtil.newHashMap(this.context);
            }
            return (T)clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

