/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.ArithmeticQueryColumn;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.QueryColumnBehavior;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class QueryColumn
implements CloneSupport<QueryColumn> {
    protected QueryTable table;
    protected String name;
    protected String alias;
    private boolean returnCopyByAsMethod = false;

    public QueryColumn() {
    }

    public QueryColumn(String name) {
        SqlUtil.keepColumnSafely(name);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String tableName, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = new QueryTable(tableName);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String schema, String tableName, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = new QueryTable(schema, tableName);
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(String schema, String tableName, String name, String alias) {
        SqlUtil.keepColumnSafely(name);
        this.returnCopyByAsMethod = true;
        this.table = new QueryTable(schema, tableName);
        this.name = StringUtil.tryTrim(name);
        this.alias = StringUtil.tryTrim(alias);
    }

    public QueryColumn(QueryTable queryTable, String name) {
        SqlUtil.keepColumnSafely(name);
        this.table = queryTable;
        this.name = StringUtil.tryTrim(name);
    }

    public QueryColumn(TableDef tableDef, String name) {
        this(tableDef, name, null);
    }

    public QueryColumn(TableDef tableDef, String name, String alias) {
        SqlUtil.keepColumnSafely(name);
        this.returnCopyByAsMethod = true;
        this.table = new QueryTable(tableDef);
        this.name = name;
        this.alias = alias;
    }

    public QueryTable getTable() {
        return this.table;
    }

    public void setTable(QueryTable table) {
        this.table = table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public <T> QueryColumn as(LambdaGetter<T> fn) {
        return this.as(fn, false);
    }

    public <T> QueryColumn as(LambdaGetter<T> fn, boolean withPrefix) {
        return this.as(LambdaUtil.getAliasName(fn, withPrefix));
    }

    public QueryColumn as(String alias) {
        SqlUtil.keepColumnSafely(alias);
        if (this.returnCopyByAsMethod) {
            QueryColumn newColumn = new QueryColumn();
            newColumn.table = this.table;
            newColumn.name = this.name;
            newColumn.alias = alias;
            return newColumn;
        }
        this.alias = alias;
        return this;
    }

    public QueryCondition eq(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " = ", value);
    }

    public <T> QueryCondition eq(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " = ", value).when(fn.test(value));
    }

    public QueryCondition ne(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " != ", value);
    }

    public <T> QueryCondition ne(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " != ", value).when(fn.test(value));
    }

    public QueryCondition like(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", "%" + value + "%");
    }

    public <T> QueryCondition like(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", "%" + value + "%").when(fn.test(value));
    }

    public QueryCondition likeLeft(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", value + "%");
    }

    public <T> QueryCondition likeLeft(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", value + "%").when(fn.test(value));
    }

    public QueryCondition likeRight(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", "%" + value);
    }

    public <T> QueryCondition likeRight(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", "%" + value).when(fn.test(value));
    }

    public QueryCondition likeRaw(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", value);
    }

    public <T> QueryCondition likeRaw(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " LIKE ", value).when(fn.test(value));
    }

    public QueryCondition notLike(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " NOT LIKE ", "%" + value + "%");
    }

    public <T> QueryCondition notLike(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " NOT LIKE ", "%" + value + "%").when(fn.test(value));
    }

    public QueryCondition notLikeLeft(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " NOT LIKE ", value + "%");
    }

    public <T> QueryCondition notLikeLeft(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " NOT LIKE ", value + "%").when(fn.test(value));
    }

    public QueryCondition notLikeRight(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " NOT LIKE ", "%" + value);
    }

    public <T> QueryCondition notLikeRight(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " NOT LIKE ", "%" + value).when(fn.test(value));
    }

    public QueryCondition gt(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " > ", value);
    }

    public <T> QueryCondition gt(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " > ", value).when(fn.test(value));
    }

    public QueryCondition ge(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " >= ", value);
    }

    public <T> QueryCondition ge(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " >= ", value).when(fn.test(value));
    }

    public QueryCondition lt(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " < ", value);
    }

    public <T> QueryCondition lt(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " < ", value).when(fn.test(value));
    }

    public QueryCondition le(Object value) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " <= ", value);
    }

    public <T> QueryCondition le(T value, Predicate<T> fn) {
        if (value == null || QueryColumnBehavior.shouldIgnoreValue(value)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " <= ", value).when(fn.test(value));
    }

    public QueryCondition isNull() {
        return QueryCondition.create(this, " IS NULL ", null);
    }

    @Deprecated
    public <T> QueryCondition isNull(Predicate<T> fn) {
        return QueryCondition.create(this, " IS NULL ", null).when(fn);
    }

    public QueryCondition isNotNull() {
        return QueryCondition.create(this, " IS NOT NULL ", null);
    }

    @Deprecated
    public <T> QueryCondition isNotNull(Predicate<T> fn) {
        return QueryCondition.create(this, " IS NOT NULL ", null).when(fn);
    }

    public QueryCondition in(Object ... arrays) {
        if (arrays == null || arrays.length == 0 || arrays.length == 1 && arrays[0] == null || QueryColumnBehavior.shouldIgnoreValue(arrays)) {
            return QueryCondition.createEmpty();
        }
        if (arrays.length == 1 && QueryColumnBehavior.isSmartConvertInToEquals()) {
            return QueryCondition.create(this, " = ", arrays[0]);
        }
        return QueryCondition.create(this, " IN ", arrays);
    }

    public <T> QueryCondition in(T[] arrays, Predicate<T[]> fn) {
        if (arrays == null || arrays.length == 0 || arrays.length == 1 && arrays[0] == null || QueryColumnBehavior.shouldIgnoreValue(arrays)) {
            return QueryCondition.createEmpty();
        }
        if (arrays.length == 1 && QueryColumnBehavior.isSmartConvertInToEquals()) {
            return QueryCondition.create(this, " = ", arrays[0]);
        }
        return QueryCondition.create(this, " IN ", arrays).when(fn.test(arrays));
    }

    public QueryCondition in(QueryWrapper queryWrapper) {
        if (queryWrapper == null || QueryColumnBehavior.shouldIgnoreValue(queryWrapper)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " IN ", queryWrapper);
    }

    @Deprecated
    public <T> QueryCondition in(QueryWrapper queryWrapper, Predicate<T> fn) {
        if (queryWrapper == null || QueryColumnBehavior.shouldIgnoreValue(queryWrapper)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " IN ", queryWrapper).when(fn);
    }

    public QueryCondition in(Collection<?> collection) {
        if (collection == null || collection.isEmpty() || QueryColumnBehavior.shouldIgnoreValue(collection)) {
            return QueryCondition.createEmpty();
        }
        return this.in(collection.toArray());
    }

    public <T extends Collection<?>> QueryCondition in(T collection, Predicate<T> fn) {
        if (collection == null || collection.isEmpty() || QueryColumnBehavior.shouldIgnoreValue(collection)) {
            return QueryCondition.createEmpty();
        }
        return this.in(collection.toArray()).when(fn.test(collection));
    }

    public QueryCondition notIn(Object ... arrays) {
        if (arrays == null || arrays.length == 0 || arrays.length == 1 && arrays[0] == null || QueryColumnBehavior.shouldIgnoreValue(arrays)) {
            return QueryCondition.createEmpty();
        }
        if (arrays.length == 1 && QueryColumnBehavior.isSmartConvertInToEquals()) {
            return QueryCondition.create(this, " != ", arrays[0]);
        }
        return QueryCondition.create(this, " NOT IN ", arrays);
    }

    public <T> QueryCondition notIn(T[] arrays, Predicate<T[]> fn) {
        if (arrays == null || arrays.length == 0 || arrays.length == 1 && arrays[0] == null || QueryColumnBehavior.shouldIgnoreValue(arrays)) {
            return QueryCondition.createEmpty();
        }
        if (arrays.length == 1 && QueryColumnBehavior.isSmartConvertInToEquals()) {
            return QueryCondition.create(this, " != ", arrays[0]);
        }
        return QueryCondition.create(this, " NOT IN ", arrays).when(fn.test(arrays));
    }

    public QueryCondition notIn(Collection<?> collection) {
        if (collection == null || collection.isEmpty() || QueryColumnBehavior.shouldIgnoreValue(collection)) {
            return QueryCondition.createEmpty();
        }
        return this.notIn(collection.toArray());
    }

    public <T extends Collection<?>> QueryCondition notIn(T collection, Predicate<T> fn) {
        if (collection == null || collection.isEmpty() || QueryColumnBehavior.shouldIgnoreValue(collection)) {
            return QueryCondition.createEmpty();
        }
        return this.notIn(collection.toArray()).when(fn.test(collection));
    }

    public QueryCondition notIn(QueryWrapper queryWrapper) {
        if (queryWrapper == null || QueryColumnBehavior.shouldIgnoreValue(queryWrapper)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " NOT IN ", queryWrapper);
    }

    @Deprecated
    public <T> QueryCondition notIn(QueryWrapper queryWrapper, Predicate<T> fn) {
        if (queryWrapper == null || QueryColumnBehavior.shouldIgnoreValue(queryWrapper)) {
            return QueryCondition.createEmpty();
        }
        return QueryCondition.create(this, " NOT IN ", queryWrapper).when(fn);
    }

    public QueryCondition between(Object start, Object end) {
        return QueryCondition.create(this, " BETWEEN ", new Object[]{start, end});
    }

    public <S, E> QueryCondition between(S start, E end, BiPredicate<S, E> fn) {
        return QueryCondition.create(this, " BETWEEN ", new Object[]{start, end}).when(fn.test(start, end));
    }

    public QueryCondition notBetween(Object start, Object end) {
        return QueryCondition.create(this, " NOT BETWEEN ", new Object[]{start, end});
    }

    public <S, E> QueryCondition notBetween(S start, E end, BiPredicate<S, E> fn) {
        return QueryCondition.create(this, " NOT BETWEEN ", new Object[]{start, end}).when(fn.test(start, end));
    }

    public QueryOrderBy asc() {
        return new QueryOrderBy(this, " ASC");
    }

    public QueryOrderBy desc() {
        return new QueryOrderBy(this, " DESC");
    }

    public QueryColumn add(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).add(queryColumn);
    }

    public QueryColumn add(Number number) {
        return new ArithmeticQueryColumn(this).add(number);
    }

    public QueryColumn subtract(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).subtract(queryColumn);
    }

    public QueryColumn subtract(Number number) {
        return new ArithmeticQueryColumn(this).subtract(number);
    }

    public QueryColumn multiply(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).multiply(queryColumn);
    }

    public QueryColumn multiply(Number number) {
        return new ArithmeticQueryColumn(this).multiply(number);
    }

    public QueryColumn divide(QueryColumn queryColumn) {
        return new ArithmeticQueryColumn(this).divide(queryColumn);
    }

    public QueryColumn divide(Number number) {
        return new ArithmeticQueryColumn(this).divide(number);
    }

    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        QueryTable selectTable = this.getSelectTable(queryTables, this.table);
        if (selectTable == null) {
            return dialect.wrap(this.name);
        }
        if (StringUtil.isNotBlank(selectTable.alias)) {
            return dialect.wrap(selectTable.alias) + "." + dialect.wrap(this.name);
        }
        if (StringUtil.isNotBlank(selectTable.getSchema()) && StringUtil.isNotBlank(selectTable.getName())) {
            return dialect.wrap(dialect.getRealSchema(selectTable.schema)) + "." + dialect.wrap(dialect.getRealTable(selectTable.getName())) + "." + dialect.wrap(this.name);
        }
        if (StringUtil.isNotBlank(selectTable.getName())) {
            return dialect.wrap(dialect.getRealTable(selectTable.getName())) + "." + dialect.wrap(this.name);
        }
        return dialect.wrap(this.name);
    }

    String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        return this.toConditionSql(queryTables, dialect) + WrapperUtil.buildAlias(this.alias, dialect);
    }

    QueryTable getSelectTable(List<QueryTable> queryTables, QueryTable selfTable) {
        if (queryTables == null || queryTables.isEmpty()) {
            return null;
        }
        if (selfTable != null && StringUtil.isNotBlank(selfTable.alias)) {
            return selfTable;
        }
        if (queryTables.size() == 1 && queryTables.get(0).isSameTable(selfTable)) {
            return null;
        }
        if (CollectionUtil.isEmpty(queryTables)) {
            return selfTable;
        }
        if (selfTable == null && queryTables.size() == 1) {
            return queryTables.get(0);
        }
        for (QueryTable table : queryTables) {
            if (!table.isSameTable(selfTable)) continue;
            return table;
        }
        return selfTable;
    }

    public String toString() {
        return "QueryColumn{table=" + this.table + ", name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + '}';
    }

    @Override
    public QueryColumn clone() {
        try {
            QueryColumn clone = (QueryColumn)super.clone();
            clone.table = ObjectUtil.clone(this.table);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

