/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.query.BaseQueryWrapper;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.SqlConnector;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class QueryConditionBuilder<Wrapper extends QueryWrapper> {
    private final Wrapper queryWrapper;
    private final QueryColumn queryColumn;
    private final SqlConnector connector;

    public QueryConditionBuilder(Wrapper queryWrapper, QueryColumn queryColumn, SqlConnector connector) {
        this.queryWrapper = queryWrapper;
        this.queryColumn = queryColumn;
        this.connector = connector;
    }

    public Wrapper eq(Object value) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.eq(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper eq(T value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.eq(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper eq(LambdaGetter<T> value) {
        return this.eq(LambdaUtil.getQueryColumn(value));
    }

    @Deprecated
    public <T> Wrapper eq(LambdaGetter<T> value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.eq(value).when(when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper ne(Object value) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.ne(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper ne(T value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.ne(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper ne(LambdaGetter<T> value) {
        return this.ne(LambdaUtil.getQueryColumn(value));
    }

    @Deprecated
    public <T> Wrapper ne(LambdaGetter<T> value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.ne(value).when(when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper like(Object value) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.like(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper like(T value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.like(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper likeLeft(Object value) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.likeLeft(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper likeLeft(T value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.likeLeft(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper likeRight(Object value) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.likeRight(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper likeRight(T value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.likeRight(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper gt(Object value) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.gt(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper gt(T value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.gt(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper gt(LambdaGetter<T> value) {
        return this.gt(LambdaUtil.getQueryColumn(value));
    }

    @Deprecated
    public <T> Wrapper gt(LambdaGetter<T> value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.gt(value).when(when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper ge(Object value) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.ge(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper ge(T value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.ge(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper ge(LambdaGetter<T> value) {
        return this.ge(LambdaUtil.getQueryColumn(value));
    }

    @Deprecated
    public <T> Wrapper ge(LambdaGetter<T> value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.ge(value).when(when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper lt(Object value) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.lt(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper lt(T value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.lt(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper lt(LambdaGetter<T> value) {
        return this.lt(LambdaUtil.getQueryColumn(value));
    }

    @Deprecated
    public <T> Wrapper lt(LambdaGetter<T> value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.lt(value).when(when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper le(Object value) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.le(value), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper le(T value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.le(value, when), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper le(LambdaGetter<T> value) {
        return this.le(LambdaUtil.getQueryColumn(value));
    }

    @Deprecated
    public <T> Wrapper le(LambdaGetter<T> value, Predicate<T> when) {
        if (value != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.le(value).when(when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper isNull() {
        ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.isNull(), this.connector);
        return this.queryWrapper;
    }

    @Deprecated
    public <T> Wrapper isNull(Predicate<T> when) {
        ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.isNull(when), this.connector);
        return this.queryWrapper;
    }

    public Wrapper isNotNull() {
        ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.isNotNull(), this.connector);
        return this.queryWrapper;
    }

    @Deprecated
    public <T> Wrapper isNotNull(Predicate<T> when) {
        ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.isNotNull(when), this.connector);
        return this.queryWrapper;
    }

    public Wrapper in(Object ... arrays) {
        if (arrays != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.in(arrays), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper in(T[] arrays, Predicate<T[]> when) {
        if (arrays != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.in(arrays, when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper in(QueryWrapper queryWrapper) {
        if (queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.in(queryWrapper), this.connector);
        }
        return this.queryWrapper;
    }

    @Deprecated
    public <T> Wrapper in(QueryWrapper queryWrapper, Predicate<T> when) {
        if (queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.in(queryWrapper, when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper in(Collection<?> collection) {
        if (this.queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.in(collection), this.connector);
        }
        return this.queryWrapper;
    }

    public <T extends Collection<?>> Wrapper in(T collection, Predicate<T> when) {
        if (this.queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.in(collection, when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper notIn(Object ... arrays) {
        if (this.queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.notIn(arrays), this.connector);
        }
        return this.queryWrapper;
    }

    public <T> Wrapper notIn(T[] arrays, Predicate<T[]> when) {
        if (this.queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.notIn(arrays, when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper notIn(Collection<?> collection) {
        if (this.queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.notIn(collection), this.connector);
        }
        return this.queryWrapper;
    }

    public <T extends Collection<?>> Wrapper notIn(T collection, Predicate<T> when) {
        if (this.queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.notIn(collection, when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper notIn(QueryWrapper queryWrapper) {
        if (queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.notIn(queryWrapper), this.connector);
        }
        return this.queryWrapper;
    }

    @Deprecated
    public <T> Wrapper notIn(QueryWrapper queryWrapper, Predicate<T> when) {
        if (queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.notIn(queryWrapper, when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper between(Object start, Object end) {
        if (this.queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.between(start, end), this.connector);
        }
        return this.queryWrapper;
    }

    public <S, E> Wrapper between(S start, E end, BiPredicate<S, E> when) {
        if (this.queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.between(start, end, when), this.connector);
        }
        return this.queryWrapper;
    }

    public Wrapper notBetween(Object start, Object end) {
        if (this.queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.notBetween(start, end), this.connector);
        }
        return this.queryWrapper;
    }

    public <S, E> Wrapper notBetween(S start, E end, BiPredicate<S, E> when) {
        if (this.queryWrapper != null) {
            ((BaseQueryWrapper)this.queryWrapper).addWhereQueryCondition(this.queryColumn.notBetween(start, end, when), this.connector);
        }
        return this.queryWrapper;
    }
}

