/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.constant.SqlOperator;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.query.BaseQueryWrapper;
import com.mybatisflex.core.query.Brackets;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.Joiner;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryConditionBuilder;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryOrderByBuilder;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.RawFragment;
import com.mybatisflex.core.query.SelectQueryTable;
import com.mybatisflex.core.query.SqlConnector;
import com.mybatisflex.core.query.StringQueryColumn;
import com.mybatisflex.core.query.StringQueryOrderBy;
import com.mybatisflex.core.query.UnionWrapper;
import com.mybatisflex.core.query.With;
import com.mybatisflex.core.query.WithBuilder;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class QueryWrapper
extends BaseQueryWrapper<QueryWrapper> {
    public static QueryWrapper create() {
        return new QueryWrapper();
    }

    public static QueryWrapper create(Object entity) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(ClassUtil.getUsefulClass(entity.getClass()));
        return tableInfo.buildQueryWrapper(entity);
    }

    public <Q extends QueryWrapper> WithBuilder<Q> with(String name) {
        if (this.with == null) {
            this.with = new With();
        }
        return new WithBuilder<QueryWrapper>(this, this.with, name);
    }

    public <Q extends QueryWrapper> WithBuilder<Q> with(String name, String ... params) {
        if (this.with == null) {
            this.with = new With();
        }
        return new WithBuilder<QueryWrapper>(this, this.with, name, Arrays.asList(params));
    }

    public <Q extends QueryWrapper> WithBuilder<Q> withRecursive(String name) {
        if (this.with == null) {
            this.with = new With(true);
        }
        return new WithBuilder<QueryWrapper>(this, this.with, name);
    }

    public <Q extends QueryWrapper> WithBuilder<Q> withRecursive(String name, String ... params) {
        if (this.with == null) {
            this.with = new With(true);
        }
        return new WithBuilder<QueryWrapper>(this, this.with, name, Arrays.asList(params));
    }

    public QueryWrapper select() {
        return this;
    }

    public QueryWrapper select(String ... columns) {
        for (String column : columns) {
            this.addSelectColumn(new StringQueryColumn(column));
        }
        return this;
    }

    public <T> QueryWrapper select(LambdaGetter<T> ... lambdaGetters) {
        for (LambdaGetter<T> lambdaGetter : lambdaGetters) {
            QueryColumn queryColumn = LambdaUtil.getQueryColumn(lambdaGetter);
            this.addSelectColumn(queryColumn);
        }
        return this;
    }

    public QueryWrapper select(QueryColumn ... queryColumns) {
        for (QueryColumn column : queryColumns) {
            if (column == null) continue;
            this.addSelectColumn(column);
        }
        return this;
    }

    public QueryWrapper select(QueryColumn[] ... queryColumns) {
        for (QueryColumn[] columnArray : queryColumns) {
            if (columnArray == null) continue;
            for (QueryColumn column : columnArray) {
                if (column == null) continue;
                this.addSelectColumn(column);
            }
        }
        return this;
    }

    public QueryWrapper select(QueryColumn[] queryColumns, QueryColumn ... queryColumns2) {
        for (QueryColumn column : queryColumns) {
            if (column == null) continue;
            this.addSelectColumn(column);
        }
        for (QueryColumn column : queryColumns2) {
            if (column == null) continue;
            this.addSelectColumn(column);
        }
        return this;
    }

    public QueryWrapper from(TableDef ... tableDefs) {
        for (TableDef tableDef : tableDefs) {
            this.from(new QueryTable(tableDef));
        }
        return this;
    }

    public QueryWrapper from(Class<?> ... entityClasses) {
        for (Class<?> entityClass : entityClasses) {
            TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
            this.from(new QueryTable(tableInfo.getSchema(), tableInfo.getTableName()));
        }
        return this;
    }

    public QueryWrapper from(String ... tables) {
        for (String table : tables) {
            if (StringUtil.isBlank(table)) {
                throw new IllegalArgumentException("table must not be null or blank.");
            }
            this.from(new QueryTable(table));
        }
        return this;
    }

    public QueryWrapper from(QueryTable ... tables) {
        if (CollectionUtil.isEmpty(this.queryTables)) {
            this.queryTables = new ArrayList();
            this.queryTables.addAll(Arrays.asList(tables));
        } else {
            for (QueryTable table : tables) {
                boolean contains = false;
                for (QueryTable queryTable : this.queryTables) {
                    if (!queryTable.isSameTable(table)) continue;
                    contains = true;
                }
                if (contains) continue;
                this.queryTables.add(table);
            }
        }
        return this;
    }

    public QueryWrapper from(QueryWrapper queryWrapper) {
        return this.from(new SelectQueryTable(queryWrapper));
    }

    public QueryWrapper as(String alias) {
        if (CollectionUtil.isEmpty(this.queryTables)) {
            throw new IllegalArgumentException("query table must not be empty.");
        }
        ((QueryTable)this.queryTables.get((int)(this.queryTables.size() - 1))).alias = alias;
        return this;
    }

    public QueryWrapper where(QueryCondition queryCondition) {
        this.setWhereQueryCondition(queryCondition);
        return this;
    }

    public QueryWrapper where(String sql) {
        this.setWhereQueryCondition(new RawFragment(sql));
        return this;
    }

    public QueryWrapper where(String sql, Object ... params) {
        this.setWhereQueryCondition(new RawFragment(sql, params));
        return this;
    }

    public QueryWrapper where(Map<String, Object> whereConditions) {
        return this.and(whereConditions);
    }

    public QueryWrapper where(Map<String, Object> whereConditions, Map<String, SqlOperator> operators) {
        return this.and(whereConditions, operators);
    }

    public <T> QueryConditionBuilder<? extends QueryWrapper> where(LambdaGetter<T> fn) {
        return new QueryConditionBuilder<QueryWrapper>(this, LambdaUtil.getQueryColumn(fn), SqlConnector.AND);
    }

    public QueryWrapper where(Consumer<QueryWrapper> consumer) {
        return this.and(consumer);
    }

    public QueryWrapper and(QueryCondition queryCondition) {
        return (QueryWrapper)this.addWhereQueryCondition(queryCondition, SqlConnector.AND);
    }

    public QueryWrapper and(String sql) {
        this.addWhereQueryCondition(new RawFragment(sql), SqlConnector.AND);
        return this;
    }

    public QueryWrapper and(String sql, Object ... params) {
        this.addWhereQueryCondition(new RawFragment(sql, params), SqlConnector.AND);
        return this;
    }

    public <T> QueryConditionBuilder<? extends QueryWrapper> and(LambdaGetter<T> fn) {
        return new QueryConditionBuilder<QueryWrapper>(this, LambdaUtil.getQueryColumn(fn), SqlConnector.AND);
    }

    public QueryWrapper and(Consumer<QueryWrapper> consumer) {
        return this.and(consumer, true);
    }

    public QueryWrapper and(Consumer<QueryWrapper> consumer, boolean condition) {
        if (!condition) {
            return this;
        }
        QueryWrapper newWrapper = new QueryWrapper();
        consumer.accept(newWrapper);
        QueryCondition whereQueryCondition = newWrapper.whereQueryCondition;
        if (whereQueryCondition != null) {
            this.and(new Brackets(whereQueryCondition));
        }
        return this;
    }

    public QueryWrapper and(Map<String, Object> whereConditions) {
        return this.and(whereConditions, Collections.emptyMap());
    }

    public QueryWrapper and(Map<String, Object> whereConditions, Map<String, SqlOperator> operators) {
        return this.connectMap(whereConditions, operators, SqlConnector.AND, SqlConnector.AND);
    }

    public QueryWrapper and(Map<String, Object> whereConditions, Map<String, SqlOperator> operators, SqlConnector innerConnector) {
        return this.connectMap(whereConditions, operators, SqlConnector.AND, innerConnector);
    }

    public QueryWrapper or(QueryCondition queryCondition) {
        return (QueryWrapper)this.addWhereQueryCondition(queryCondition, SqlConnector.OR);
    }

    public QueryWrapper or(String sql) {
        this.addWhereQueryCondition(new RawFragment(sql), SqlConnector.OR);
        return this;
    }

    public QueryWrapper or(String sql, Object ... params) {
        this.addWhereQueryCondition(new RawFragment(sql, params), SqlConnector.OR);
        return this;
    }

    public <T> QueryConditionBuilder<? extends QueryWrapper> or(LambdaGetter<T> fn) {
        return new QueryConditionBuilder<QueryWrapper>(this, LambdaUtil.getQueryColumn(fn), SqlConnector.OR);
    }

    public QueryWrapper or(Consumer<QueryWrapper> consumer) {
        return this.or(consumer, true);
    }

    public QueryWrapper or(Consumer<QueryWrapper> consumer, boolean condition) {
        if (!condition) {
            return this;
        }
        QueryWrapper newWrapper = new QueryWrapper();
        consumer.accept(newWrapper);
        QueryCondition whereQueryCondition = newWrapper.whereQueryCondition;
        if (whereQueryCondition != null) {
            this.or(new Brackets(whereQueryCondition));
        }
        return this;
    }

    public QueryWrapper or(Map<String, Object> whereConditions) {
        return this.or(whereConditions, Collections.emptyMap());
    }

    public QueryWrapper or(Map<String, Object> whereConditions, Map<String, SqlOperator> operators) {
        return this.connectMap(whereConditions, operators, SqlConnector.OR, SqlConnector.AND);
    }

    public QueryWrapper or(Map<String, Object> whereConditions, Map<String, SqlOperator> operators, SqlConnector innerConnector) {
        return this.connectMap(whereConditions, operators, SqlConnector.OR, SqlConnector.AND);
    }

    protected QueryWrapper connectMap(Map<String, Object> mapConditions, Map<String, SqlOperator> operators, SqlConnector outerConnector, SqlConnector innerConnector) {
        if (operators == null) {
            operators = Collections.emptyMap();
        }
        if (mapConditions != null) {
            QueryCondition condition = null;
            for (Map.Entry<String, Object> entry : mapConditions.entrySet()) {
                SqlOperator operator = operators.get(entry.getKey());
                if (operator == null) {
                    operator = SqlOperator.EQUALS;
                }
                QueryCondition cond = QueryCondition.create(new QueryColumn(entry.getKey()), operator.getValue(), entry.getValue());
                if (condition == null) {
                    condition = cond;
                    continue;
                }
                if (innerConnector == SqlConnector.AND) {
                    condition.and(cond);
                    continue;
                }
                condition.or(cond);
            }
            this.addWhereQueryCondition(condition, outerConnector);
        }
        return this;
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(String table) {
        return this.joining(" LEFT JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(String table, boolean when) {
        return this.joining(" LEFT JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(Class<?> entityClass) {
        return this.joining(" LEFT JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(Class<?> entityClass, boolean when) {
        return this.joining(" LEFT JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(TableDef table) {
        return this.joining(" LEFT JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(TableDef table, boolean when) {
        return this.joining(" LEFT JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(QueryWrapper table) {
        return this.joining(" LEFT JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> leftJoin(QueryWrapper table, boolean when) {
        return this.joining(" LEFT JOIN ", table, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(String table) {
        return this.joining(" RIGHT JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(String table, boolean when) {
        return this.joining(" RIGHT JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(Class<?> entityClass) {
        return this.joining(" RIGHT JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(Class<?> entityClass, boolean when) {
        return this.joining(" RIGHT JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(TableDef table) {
        return this.joining(" RIGHT JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(TableDef table, boolean when) {
        return this.joining(" RIGHT JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(QueryWrapper table) {
        return this.joining(" RIGHT JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> rightJoin(QueryWrapper table, boolean when) {
        return this.joining(" RIGHT JOIN ", table, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(String table) {
        return this.joining(" INNER JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(String table, boolean when) {
        return this.joining(" INNER JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(Class<?> entityClass) {
        return this.joining(" INNER JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(Class<?> entityClass, boolean when) {
        return this.joining(" INNER JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(TableDef table) {
        return this.innerJoin(table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(TableDef table, boolean when) {
        return this.joining(" INNER JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(QueryWrapper table) {
        return this.joining(" INNER JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> innerJoin(QueryWrapper table, boolean when) {
        return this.joining(" INNER JOIN ", table, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(String table) {
        return this.joining(" FULL JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(String table, boolean when) {
        return this.joining(" FULL JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(Class<?> entityClass) {
        return this.joining(" FULL JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(Class<?> entityClass, boolean when) {
        return this.joining(" FULL JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(TableDef table) {
        return this.joining(" FULL JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(TableDef table, boolean when) {
        return this.joining(" FULL JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(QueryWrapper table) {
        return this.joining(" FULL JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> fullJoin(QueryWrapper table, boolean when) {
        return this.joining(" FULL JOIN ", table, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(String table) {
        return this.joining(" CROSS JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(String table, boolean when) {
        return this.joining(" CROSS JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(Class<?> entityClass) {
        return this.joining(" CROSS JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(Class<?> entityClass, boolean when) {
        return this.joining(" CROSS JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(TableDef table) {
        return this.joining(" CROSS JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(TableDef table, boolean when) {
        return this.joining(" CROSS JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(QueryWrapper table) {
        return this.joining(" CROSS JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> crossJoin(QueryWrapper table, boolean when) {
        return this.joining(" CROSS JOIN ", table, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(String table) {
        return this.joining(" JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(String table, boolean when) {
        return this.joining(" JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(Class<?> entityClass) {
        return this.joining(" JOIN ", entityClass, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(Class<?> entityClass, boolean when) {
        return this.joining(" JOIN ", entityClass, when);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(TableDef table) {
        return this.joining(" JOIN ", new QueryTable(table), true);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(TableDef table, boolean when) {
        return this.joining(" JOIN ", new QueryTable(table), when);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(QueryWrapper table) {
        return this.joining(" JOIN ", table, true);
    }

    public <Q extends QueryWrapper> Joiner<Q> join(QueryWrapper table, boolean when) {
        return this.joining(" JOIN ", table, when);
    }

    public QueryWrapper union(QueryWrapper unionQuery) {
        if (this.unions == null) {
            this.unions = new ArrayList();
        }
        this.unions.add(UnionWrapper.union(unionQuery));
        return this;
    }

    public QueryWrapper unionAll(QueryWrapper unionQuery) {
        if (this.unions == null) {
            this.unions = new ArrayList();
        }
        this.unions.add(UnionWrapper.unionAll(unionQuery));
        return this;
    }

    public QueryWrapper forUpdate() {
        this.addEndFragment("FOR UPDATE");
        return this;
    }

    public QueryWrapper forUpdateNoWait() {
        this.addEndFragment("FOR UPDATE NOWAIT");
        return this;
    }

    protected <T extends QueryWrapper> Joiner<T> joining(String type, QueryTable table, boolean when) {
        Join join = new Join(type, table, when);
        this.addJoinTable(join.getQueryTable());
        return new Joiner<QueryWrapper>((QueryWrapper)this.addJoin(join), join);
    }

    protected <T extends QueryWrapper> Joiner<T> joining(String type, Class<?> entityClass, boolean when) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        QueryTable queryTable = new QueryTable(tableInfo.getSchema(), tableInfo.getTableName());
        return this.joining(type, queryTable, when);
    }

    protected <T extends QueryWrapper> Joiner<T> joining(String type, QueryWrapper queryWrapper, boolean when) {
        Join join = new Join(type, queryWrapper, when);
        this.addJoinTable(join.getQueryTable());
        return new Joiner<QueryWrapper>((QueryWrapper)this.addJoin(join), join);
    }

    public QueryWrapper groupBy(String name) {
        this.addGroupByColumns(new QueryColumn(name));
        return this;
    }

    public QueryWrapper groupBy(String ... names) {
        for (String name : names) {
            this.groupBy(name);
        }
        return this;
    }

    public QueryWrapper groupBy(QueryColumn column) {
        this.addGroupByColumns(column);
        return this;
    }

    public QueryWrapper groupBy(QueryColumn ... columns) {
        for (QueryColumn column : columns) {
            this.groupBy(column);
        }
        return this;
    }

    public <T> QueryWrapper groupBy(LambdaGetter<T> column) {
        this.addGroupByColumns(LambdaUtil.getQueryColumn(column));
        return this;
    }

    public <T> QueryWrapper groupBy(LambdaGetter<T> ... columns) {
        for (LambdaGetter<T> column : columns) {
            this.groupBy(LambdaUtil.getQueryColumn(column));
        }
        return this;
    }

    public QueryWrapper having(QueryCondition queryCondition) {
        this.addHavingQueryCondition(queryCondition, SqlConnector.AND);
        return this;
    }

    public QueryWrapper orderBy(QueryOrderBy ... orderBys) {
        for (QueryOrderBy queryOrderBy : orderBys) {
            this.addOrderBy(queryOrderBy);
        }
        return this;
    }

    public <T> QueryOrderByBuilder<? extends QueryWrapper> orderBy(LambdaGetter<T> getter) {
        return new QueryOrderByBuilder<QueryWrapper>(this, getter);
    }

    public QueryWrapper orderBy(String ... orderBys) {
        if (orderBys == null || orderBys.length == 0) {
            return this;
        }
        for (String queryOrderBy : orderBys) {
            if (!StringUtil.isNotBlank(queryOrderBy)) continue;
            this.addOrderBy(new StringQueryOrderBy(queryOrderBy));
        }
        return this;
    }

    public QueryWrapper limit(Number rows) {
        if (rows != null) {
            this.setLimitRows(rows.longValue());
        } else {
            this.setLimitRows(null);
        }
        return this;
    }

    public QueryWrapper offset(Number offset) {
        if (offset != null) {
            this.setLimitOffset(offset.longValue());
        } else {
            this.setLimitOffset(null);
        }
        return this;
    }

    public QueryWrapper limit(Number offset, Number rows) {
        this.offset(offset);
        this.limit(rows);
        return this;
    }

    public QueryWrapper datasource(String datasource) {
        this.setDataSource(datasource);
        return this;
    }

    public QueryWrapper hint(String hint) {
        this.setHint(hint);
        return this;
    }

    Object[] getAllValueArray() {
        Object[] paramValues;
        ArrayList<Object> withValues = null;
        if (this.with != null && ArrayUtil.isNotEmpty(paramValues = this.with.getParamValues())) {
            withValues = new ArrayList<Object>(Arrays.asList(paramValues));
        }
        ArrayList<Object> columnValues = null;
        List<QueryColumn> selectColumns = this.getSelectColumns();
        if (CollectionUtil.isNotEmpty(selectColumns)) {
            for (QueryColumn selectColumn : selectColumns) {
                Object[] paramValues2;
                if (!(selectColumn instanceof HasParamsColumn) || !ArrayUtil.isNotEmpty(paramValues2 = ((HasParamsColumn)((Object)selectColumn)).getParamValues())) continue;
                if (columnValues == null) {
                    columnValues = new ArrayList<Object>(paramValues2.length);
                }
                columnValues.addAll(Arrays.asList(paramValues2));
            }
        }
        ArrayList<Object> tableValues = null;
        List<QueryTable> queryTables = this.getQueryTables();
        if (CollectionUtil.isNotEmpty(queryTables)) {
            for (QueryTable queryTable : queryTables) {
                Object[] tableValueArray = queryTable.getValueArray();
                if (tableValueArray.length <= 0) continue;
                if (tableValues == null) {
                    tableValues = new ArrayList<Object>(tableValueArray.length);
                }
                tableValues.addAll(Arrays.asList(tableValueArray));
            }
        }
        ArrayList<Object> joinValues = null;
        List<Join> joins = this.getJoins();
        if (CollectionUtil.isNotEmpty(joins)) {
            for (Join join : joins) {
                QueryCondition onCondition;
                Object[] values;
                QueryTable joinTable = join.getQueryTable();
                Object[] valueArray = joinTable.getValueArray();
                if (valueArray.length > 0) {
                    if (joinValues == null) {
                        joinValues = new ArrayList<Object>(valueArray.length);
                    }
                    joinValues.addAll(Arrays.asList(valueArray));
                }
                if ((values = WrapperUtil.getValues(onCondition = join.getOnCondition())).length <= 0) continue;
                if (joinValues == null) {
                    joinValues = new ArrayList(values.length);
                }
                joinValues.addAll(Arrays.asList(values));
            }
        }
        Object[] whereValues = WrapperUtil.getValues(this.whereQueryCondition);
        Object[] havingValues = WrapperUtil.getValues(this.havingQueryCondition);
        Object[] paramValues3 = ArrayUtil.concat(whereValues, havingValues);
        if (CollectionUtil.isNotEmpty(this.unions)) {
            for (UnionWrapper union : this.unions) {
                QueryWrapper queryWrapper = union.getQueryWrapper();
                paramValues3 = ArrayUtil.concat(paramValues3, queryWrapper.getAllValueArray());
            }
        }
        Object[] returnValues = withValues == null ? FlexConsts.EMPTY_ARRAY : withValues.toArray();
        returnValues = columnValues != null ? ArrayUtil.concat(returnValues, columnValues.toArray()) : returnValues;
        returnValues = tableValues != null ? ArrayUtil.concat(returnValues, tableValues.toArray()) : returnValues;
        returnValues = joinValues != null ? ArrayUtil.concat(returnValues, joinValues.toArray()) : returnValues;
        returnValues = ArrayUtil.concat(returnValues, paramValues3);
        return returnValues;
    }

    Object[] getJoinValueArray() {
        ArrayList<Object> joinValues = null;
        List<Join> joins = this.getJoins();
        if (CollectionUtil.isNotEmpty(joins)) {
            for (Join join : joins) {
                QueryCondition onCondition;
                Object[] values;
                QueryTable joinTable = join.getQueryTable();
                Object[] valueArray = joinTable.getValueArray();
                if (valueArray.length > 0) {
                    if (joinValues == null) {
                        joinValues = new ArrayList<Object>(valueArray.length);
                    }
                    joinValues.addAll(Arrays.asList(valueArray));
                }
                if ((values = WrapperUtil.getValues(onCondition = join.getOnCondition())).length <= 0) continue;
                if (joinValues == null) {
                    joinValues = new ArrayList(values.length);
                }
                joinValues.addAll(Arrays.asList(values));
            }
        }
        return joinValues == null ? FlexConsts.EMPTY_ARRAY : joinValues.toArray();
    }

    Object[] getConditionValueArray() {
        Object[] whereValues = WrapperUtil.getValues(this.whereQueryCondition);
        Object[] havingValues = WrapperUtil.getValues(this.havingQueryCondition);
        Object[] paramValues = ArrayUtil.concat(whereValues, havingValues);
        if (CollectionUtil.isNotEmpty(this.unions)) {
            for (UnionWrapper union : this.unions) {
                QueryWrapper queryWrapper = union.getQueryWrapper();
                paramValues = ArrayUtil.concat(paramValues, queryWrapper.getAllValueArray());
            }
        }
        return paramValues;
    }

    List<QueryWrapper> getChildSelect() {
        ArrayList<QueryWrapper> tableChildQuery = null;
        List<QueryTable> queryTables = this.getQueryTables();
        if (CollectionUtil.isNotEmpty(queryTables)) {
            for (QueryTable queryTable : queryTables) {
                if (!(queryTable instanceof SelectQueryTable)) continue;
                if (tableChildQuery == null) {
                    tableChildQuery = new ArrayList<QueryWrapper>();
                }
                tableChildQuery.add(((SelectQueryTable)queryTable).getQueryWrapper());
            }
        }
        List<QueryWrapper> whereChildQuery = WrapperUtil.getChildQueryWrapper(this.whereQueryCondition);
        List<QueryWrapper> havingChildQuery = WrapperUtil.getChildQueryWrapper(this.havingQueryCondition);
        if (tableChildQuery == null && whereChildQuery.isEmpty() && havingChildQuery.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QueryWrapper> childQueryWrappers = tableChildQuery == null ? new ArrayList<QueryWrapper>() : new ArrayList(tableChildQuery);
        childQueryWrappers.addAll(whereChildQuery);
        childQueryWrappers.addAll(havingChildQuery);
        return childQueryWrappers;
    }

    public String toSQL() {
        String sql = DialectFactory.getDialect().forSelectByQuery(this);
        return SqlUtil.replaceSqlParams(sql, this.getAllValueArray());
    }

    @Override
    public QueryWrapper clone() {
        return (QueryWrapper)super.clone();
    }
}

