/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.table;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.ColumnAlias;
import com.mybatisflex.annotation.ColumnMask;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.NoneListener;
import com.mybatisflex.annotation.SetListener;
import com.mybatisflex.annotation.Table;
import com.mybatisflex.annotation.UpdateListener;
import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.table.ColumnInfo;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.Reflectors;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.apache.ibatis.util.MapUtil;

public class TableInfoFactory {
    static final Set<Class<?>> defaultSupportColumnTypes = CollectionUtil.newHashSet(Integer.TYPE, Integer.class, Short.TYPE, Short.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, java.util.Date.class, Date.class, Time.class, Timestamp.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, OffsetDateTime.class, OffsetTime.class, ZonedDateTime.class, Year.class, Month.class, YearMonth.class, JapaneseDate.class, byte[].class, Byte[].class, Byte.class, BigInteger.class, BigDecimal.class, Character.TYPE, String.class, Character.class);
    private static final Map<Class<?>, TableInfo> mapperTableInfoMap = new ConcurrentHashMap();
    private static final Map<Class<?>, TableInfo> entityTableMap = new ConcurrentHashMap();
    private static final Map<String, TableInfo> tableInfoMap = new ConcurrentHashMap<String, TableInfo>();
    private static final Set<String> initedPackageNames = new HashSet<String>();

    private TableInfoFactory() {
    }

    public static synchronized void init(String mapperPackageName) {
        if (!initedPackageNames.contains(mapperPackageName)) {
            ResolverUtil resolverUtil = new ResolverUtil();
            resolverUtil.find((ResolverUtil.Test)new ResolverUtil.IsA(BaseMapper.class), mapperPackageName);
            Set mapperSet = resolverUtil.getClasses();
            for (Class mapperClass : mapperSet) {
                TableInfoFactory.ofMapperClass(mapperClass);
            }
            initedPackageNames.add(mapperPackageName);
        }
    }

    public static TableInfo ofMapperClass(Class<?> mapperClass) {
        return (TableInfo)MapUtil.computeIfAbsent(mapperTableInfoMap, mapperClass, key -> {
            Class<?> entityClass = TableInfoFactory.getEntityClass(mapperClass);
            if (entityClass == null) {
                return null;
            }
            return TableInfoFactory.ofEntityClass(entityClass);
        });
    }

    public static TableInfo ofEntityClass(Class<?> entityClass) {
        return (TableInfo)MapUtil.computeIfAbsent(entityTableMap, entityClass, aClass -> {
            TableInfo tableInfo = TableInfoFactory.createTableInfo(entityClass);
            tableInfoMap.put(tableInfo.getTableNameWithSchema(), tableInfo);
            return tableInfo;
        });
    }

    public static TableInfo ofTableName(String tableName) {
        return StringUtil.isNotBlank(tableName) ? tableInfoMap.get(tableName) : null;
    }

    private static Class<?> getEntityClass(Class<?> mapperClass) {
        if (mapperClass == null || mapperClass == Object.class) {
            return null;
        }
        Type[] genericInterfaces = mapperClass.getGenericInterfaces();
        if (genericInterfaces.length == 1) {
            Type type = genericInterfaces[0];
            if (type instanceof ParameterizedType) {
                Type actualTypeArgument = ((ParameterizedType)type).getActualTypeArguments()[0];
                return actualTypeArgument instanceof Class ? (Class)actualTypeArgument : null;
            }
            if (type instanceof Class) {
                return TableInfoFactory.getEntityClass((Class)type);
            }
        }
        return TableInfoFactory.getEntityClass(mapperClass.getSuperclass());
    }

    private static TableInfo createTableInfo(Class<?> entityClass) {
        TableInfo tableInfo = new TableInfo();
        tableInfo.setEntityClass(entityClass);
        Reflector reflector = Reflectors.of(entityClass);
        tableInfo.setReflector(reflector);
        Table table = entityClass.getAnnotation(Table.class);
        if (table != null) {
            tableInfo.setTableName(table.value());
            tableInfo.setSchema(table.schema());
            tableInfo.setCamelToUnderline(table.camelToUnderline());
            if (table.onInsert().length > 0) {
                List<InsertListener> insertListeners = Arrays.stream(table.onInsert()).filter(listener -> listener != NoneListener.class).map(ClassUtil::newInstance).collect(Collectors.toList());
                tableInfo.setOnInsertListeners(insertListeners);
            }
            if (table.onUpdate().length > 0) {
                List<UpdateListener> updateListeners = Arrays.stream(table.onUpdate()).filter(listener -> listener != NoneListener.class).map(ClassUtil::newInstance).collect(Collectors.toList());
                tableInfo.setOnUpdateListeners(updateListeners);
            }
            if (table.onSet().length > 0) {
                List<SetListener> setListeners = Arrays.stream(table.onSet()).filter(listener -> listener != NoneListener.class).map(ClassUtil::newInstance).collect(Collectors.toList());
                tableInfo.setOnSetListeners(setListeners);
            }
            if (StringUtil.isNotBlank(table.dataSource())) {
                tableInfo.setDataSource(table.dataSource());
            }
        } else {
            String tableName = StringUtil.camelToUnderline(entityClass.getSimpleName());
            tableInfo.setTableName(tableName);
        }
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
        ArrayList<IdInfo> idInfos = new ArrayList<IdInfo>();
        String logicDeleteColumn = null;
        String versionColumn = null;
        String tenantIdColumn = null;
        HashMap<String, String> onInsertColumns = new HashMap<String, String>();
        HashMap<String, String> onUpdateColumns = new HashMap<String, String>();
        LinkedHashSet<String> largeColumns = new LinkedHashSet<String>();
        LinkedHashSet<String> defaultQueryColumns = new LinkedHashSet<String>();
        List<Field> entityFields = TableInfoFactory.getColumnFields(entityClass);
        FlexGlobalConfig config = FlexGlobalConfig.getDefaultConfig();
        for (Field field : entityFields) {
            ColumnMask columnMask;
            ColumnInfo columnInfo;
            Id id;
            Column column = field.getAnnotation(Column.class);
            if (column != null && column.ignore()) continue;
            Class fieldType = reflector.getGetterType(field.getName());
            if (!(column != null && column.typeHandler() != UnknownTypeHandler.class || fieldType.isEnum() || defaultSupportColumnTypes.contains(fieldType))) {
                if (Collection.class.isAssignableFrom(fieldType)) {
                    Type actualTypeArgument;
                    Type genericType = TypeParameterResolver.resolveFieldType((Field)field, entityClass);
                    if (!(genericType instanceof ParameterizedType) || !((actualTypeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class)) continue;
                    tableInfo.addCollectionType(field, (Class)actualTypeArgument);
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldType) || fieldType.isArray()) continue;
                tableInfo.addAssociationType(field.getName(), fieldType);
                continue;
            }
            String columnName = TableInfoFactory.getColumnName(tableInfo.isCamelToUnderline(), field, column);
            if (column != null && column.isLogicDelete() || columnName.equals(config.getLogicDeleteColumn())) {
                if (logicDeleteColumn == null) {
                    logicDeleteColumn = columnName;
                } else {
                    throw FlexExceptions.wrap("The logic delete column of entity[%s] must be less then 2.", entityClass.getName());
                }
            }
            if (column != null && column.version() || columnName.equals(config.getVersionColumn())) {
                if (versionColumn == null) {
                    versionColumn = columnName;
                } else {
                    throw FlexExceptions.wrap("The version column of entity[%s] must be less then 2.", entityClass.getName());
                }
            }
            if (column != null && column.tenantId() || columnName.equals(config.getTenantColumn())) {
                if (tenantIdColumn == null) {
                    tenantIdColumn = columnName;
                } else {
                    throw FlexExceptions.wrap("The tenantId column of entity[%s] must be less then 2.", entityClass.getName());
                }
            }
            if (column != null && StringUtil.isNotBlank(column.onInsertValue())) {
                onInsertColumns.put(columnName, column.onInsertValue().trim());
            }
            if (column != null && StringUtil.isNotBlank(column.onUpdateValue())) {
                onUpdateColumns.put(columnName, column.onUpdateValue().trim());
            }
            if (column != null && column.isLarge()) {
                largeColumns.add(columnName);
            }
            if (column == null || !column.isLarge()) {
                defaultQueryColumns.add(columnName);
            }
            if ((id = field.getAnnotation(Id.class)) != null) {
                columnInfo = new IdInfo(id);
                idInfos.add((IdInfo)columnInfo);
            } else {
                columnInfo = new ColumnInfo();
                columnInfoList.add(columnInfo);
            }
            ColumnAlias columnAlias = null;
            Method getterMethod = ClassUtil.getFirstMethod(entityClass, m -> ClassUtil.isGetterMethod(m, field.getName()));
            if (getterMethod != null) {
                columnAlias = getterMethod.getAnnotation(ColumnAlias.class);
            }
            if (columnAlias == null) {
                columnAlias = field.getAnnotation(ColumnAlias.class);
            }
            if (columnAlias != null) {
                columnInfo.setAlias(columnAlias.value());
            }
            columnInfo.setColumn(columnName);
            columnInfo.setProperty(field.getName());
            columnInfo.setPropertyType(fieldType);
            if (column != null && column.typeHandler() != UnknownTypeHandler.class) {
                TypeHandler typeHandler;
                if (Collection.class.isAssignableFrom(fieldType)) {
                    typeHandler = TableInfoFactory.createCollectionTypeHandler(entityClass, field, column.typeHandler(), fieldType);
                } else {
                    Class typeHandlerClass = column.typeHandler();
                    Configuration configuration = FlexGlobalConfig.getDefaultConfig().getConfiguration();
                    TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
                    typeHandler = typeHandlerRegistry.getInstance(columnInfo.getPropertyType(), typeHandlerClass);
                }
                columnInfo.setTypeHandler(typeHandler);
            }
            if ((columnMask = field.getAnnotation(ColumnMask.class)) != null && StringUtil.isNotBlank(columnMask.value())) {
                if (String.class != fieldType) {
                    throw new IllegalStateException("@ColumnMask() only support for string type field. error: " + entityClass.getName() + "." + field.getName());
                }
                columnInfo.setMaskType(columnMask.value().trim());
            }
            if (column == null || column.jdbcType() == JdbcType.UNDEFINED) continue;
            columnInfo.setJdbcType(column.jdbcType());
        }
        tableInfo.setLogicDeleteColumn(logicDeleteColumn);
        tableInfo.setVersionColumn(versionColumn);
        tableInfo.setTenantIdColumn(tenantIdColumn);
        if (!onInsertColumns.isEmpty()) {
            tableInfo.setOnInsertColumns(onInsertColumns);
        }
        if (!onUpdateColumns.isEmpty()) {
            tableInfo.setOnUpdateColumns(onUpdateColumns);
        }
        if (!largeColumns.isEmpty()) {
            tableInfo.setLargeColumns(largeColumns.toArray(new String[0]));
        }
        if (!defaultQueryColumns.isEmpty()) {
            tableInfo.setDefaultQueryColumns(defaultQueryColumns.toArray(new String[0]));
        }
        tableInfo.setPrimaryKeyList(idInfos);
        tableInfo.setColumnInfoList(columnInfoList);
        return tableInfo;
    }

    private static TypeHandler<?> createCollectionTypeHandler(Class<?> entityClass, Field field, Class<?> typeHandlerClass, Class<?> fieldType) {
        Type actualTypeArgument;
        Class genericClass = null;
        Type genericType = TypeParameterResolver.resolveFieldType((Field)field, entityClass);
        if (genericType instanceof ParameterizedType && (actualTypeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
            genericClass = (Class)actualTypeArgument;
        }
        try {
            Constructor<?> constructor = typeHandlerClass.getConstructor(Class.class, Class.class);
            return (TypeHandler)constructor.newInstance(fieldType, genericClass);
        }
        catch (NoSuchMethodException constructor) {
        }
        catch (Exception e) {
            throw new TypeException("Failed invoking constructor for handler " + typeHandlerClass, (Throwable)e);
        }
        try {
            Constructor<?> constructor = typeHandlerClass.getConstructor(Class.class);
            return (TypeHandler)constructor.newInstance(fieldType);
        }
        catch (NoSuchMethodException constructor) {
        }
        catch (Exception e) {
            throw new TypeException("Failed invoking constructor for handler " + typeHandlerClass, (Throwable)e);
        }
        try {
            Constructor<?> c = typeHandlerClass.getConstructor(new Class[0]);
            return (TypeHandler)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new TypeException("Unable to find a usable constructor for " + typeHandlerClass, (Throwable)e);
        }
    }

    static String getColumnName(boolean isCamelToUnderline, Field field, Column column) {
        if (column != null && StringUtil.isNotBlank(column.value())) {
            return column.value();
        }
        if (isCamelToUnderline) {
            return StringUtil.camelToUnderline(field.getName());
        }
        return field.getName();
    }

    public static List<Field> getColumnFields(Class<?> entityClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        TableInfoFactory.doGetFields(entityClass, fields);
        return fields;
    }

    private static void doGetFields(Class<?> entityClass, List<Field> fields) {
        Field[] declaredFields;
        if (entityClass == null || entityClass == Object.class) {
            return;
        }
        for (Field declaredField : declaredFields = entityClass.getDeclaredFields()) {
            if (Modifier.isStatic(declaredField.getModifiers()) || TableInfoFactory.existName(fields, declaredField)) continue;
            fields.add(declaredField);
        }
        TableInfoFactory.doGetFields(entityClass.getSuperclass(), fields);
    }

    private static boolean existName(List<Field> fields, Field field) {
        for (Field f : fields) {
            if (!f.getName().equalsIgnoreCase(field.getName())) continue;
            return true;
        }
        return false;
    }
}

