/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.update;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.update.ModifyAttrsRecordHandler;
import com.mybatisflex.core.update.RawValue;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.UpdateEntity;
import java.io.Serializable;
import java.util.Map;
import org.apache.ibatis.javassist.util.proxy.ProxyObject;

public interface UpdateWrapper
extends Serializable {
    default public Map<String, Object> getUpdates() {
        ModifyAttrsRecordHandler handler = (ModifyAttrsRecordHandler)((ProxyObject)this).getHandler();
        return handler.getUpdates();
    }

    default public UpdateWrapper set(String property, Object value, boolean condition) {
        if (condition) {
            return this.set(property, value);
        }
        return this;
    }

    default public UpdateWrapper set(String property, Object value) {
        if (value instanceof QueryWrapper || value instanceof QueryCondition || value instanceof QueryColumn) {
            this.setRaw(property, value);
        } else {
            this.getUpdates().put(property, value);
        }
        return this;
    }

    default public <T> UpdateWrapper set(LambdaGetter<T> getter, Object value, boolean condition) {
        if (condition) {
            return this.set(getter, value);
        }
        return this;
    }

    default public <T> UpdateWrapper set(LambdaGetter<T> getter, Object value) {
        if (value instanceof QueryWrapper || value instanceof QueryCondition || value instanceof QueryColumn) {
            this.setRaw(getter, value);
        } else {
            this.getUpdates().put(LambdaUtil.getFieldName(getter), value);
        }
        return this;
    }

    default public <T> UpdateWrapper set(QueryColumn queryColumn, Object value, boolean condition) {
        if (condition) {
            return this.set(queryColumn, value);
        }
        return this;
    }

    default public <T> UpdateWrapper set(QueryColumn queryColumn, Object value) {
        if (value instanceof QueryWrapper || value instanceof QueryCondition || value instanceof QueryColumn) {
            this.setRaw(queryColumn, value);
        } else {
            this.getUpdates().put(queryColumn.getName(), value);
        }
        return this;
    }

    default public UpdateWrapper setRaw(String property, Object value, boolean condition) {
        if (condition) {
            return this.setRaw(property, value);
        }
        return this;
    }

    default public UpdateWrapper setRaw(String property, Object value) {
        this.getUpdates().put(property, new RawValue(value));
        return this;
    }

    default public <T> UpdateWrapper setRaw(LambdaGetter<T> getter, Object value, boolean condition) {
        if (condition) {
            return this.setRaw(getter, value);
        }
        return this;
    }

    default public <T> UpdateWrapper setRaw(LambdaGetter<T> getter, Object value) {
        this.getUpdates().put(LambdaUtil.getFieldName(getter), new RawValue(value));
        return this;
    }

    default public <T> UpdateWrapper setRaw(QueryColumn queryColumn, Object value, boolean condition) {
        if (condition) {
            return this.setRaw(queryColumn, value);
        }
        return this;
    }

    default public <T> UpdateWrapper setRaw(QueryColumn queryColumn, Object value) {
        this.getUpdates().put(queryColumn.getName(), new RawValue(value));
        return this;
    }

    public static UpdateWrapper of(Object entity) {
        if (entity instanceof UpdateWrapper) {
            return (UpdateWrapper)entity;
        }
        return (UpdateWrapper)UpdateEntity.ofNotNull(entity);
    }
}

