/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.DateUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Array;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.StringJoiner;
import java.util.regex.Matcher;

public class SqlUtil {
    private static final String SQL_ORDER_BY_PATTERN = "[a-zA-Z0-9_\\ \\,\\.]+";
    private static final char[] UN_SAFE_CHARS = "'`\"<>&+=#-;".toCharArray();

    private SqlUtil() {
    }

    public static void keepColumnSafely(String column) {
        if (StringUtil.isBlank(column)) {
            throw new IllegalArgumentException("Column must not be empty");
        }
        column = column.trim();
        int strLen = column.length();
        for (int i = 0; i < strLen; ++i) {
            char ch = column.charAt(i);
            if (Character.isWhitespace(ch)) {
                throw new IllegalArgumentException("Column must not has space char.");
            }
            if (!SqlUtil.isUnSafeChar(ch)) continue;
            throw new IllegalArgumentException("Column has unsafe char: [" + ch + "].");
        }
    }

    public static void keepOrderBySqlSafely(String value) {
        if (!value.matches(SQL_ORDER_BY_PATTERN)) {
            throw new IllegalArgumentException("Order By sql not safe, order by string: " + value);
        }
    }

    private static boolean isUnSafeChar(char ch) {
        for (char c : UN_SAFE_CHARS) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static boolean toBool(Number result) {
        return result != null && result.intValue() > 0;
    }

    public static boolean toBool(int[] results) {
        for (int result : results) {
            if (result <= 0) continue;
            return true;
        }
        return false;
    }

    public static String replaceSqlParams(String sql, Object[] params) {
        if (params == null || params.length == 0) {
            return sql;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        char quote = '\u0000';
        int index = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '\'') {
                if (quote == '\u0000') {
                    quote = ch;
                } else if (quote == '\'') {
                    quote = '\u0000';
                }
            } else if (ch == '\"') {
                if (quote == '\u0000') {
                    quote = ch;
                } else if (quote == '\"') {
                    quote = '\u0000';
                }
            }
            if (quote == '\u0000' && ch == '?' && index < params.length) {
                sqlBuilder.append(SqlUtil.getParamString(params, index++));
                continue;
            }
            sqlBuilder.append(ch);
        }
        return sqlBuilder.toString();
    }

    private static String getParamString(Object[] params, int index) {
        Object value = params[index];
        if (value == null) {
            return "null";
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (ClassUtil.isArray(value.getClass())) {
            StringJoiner joiner = new StringJoiner(",", "[", "]");
            for (int i = 0; i < Array.getLength(value); ++i) {
                joiner.add(String.valueOf(Array.get(value, i)));
            }
            return joiner.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        if (value instanceof Date) {
            sb.append(DateUtil.toDateTimeString((Date)value));
        } else if (value instanceof LocalDateTime) {
            sb.append(((LocalDateTime)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        } else {
            sb.append(value);
        }
        sb.append("'");
        return Matcher.quoteReplacement(sb.toString());
    }

    public static String buildSqlParamPlaceholder(int count) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < count; ++i) {
            sb.append("?");
            if (i == count - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

