/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ArithmeticQueryColumn
extends QueryColumn {
    private List<ArithmeticInfo> arithmeticInfos = new ArrayList<ArithmeticInfo>();

    public ArithmeticQueryColumn(Object value) {
        this.arithmeticInfos.add(new ArithmeticInfo(value));
    }

    @Override
    public QueryColumn add(QueryColumn queryColumn) {
        this.arithmeticInfos.add(new ArithmeticInfo(" + ", queryColumn));
        return this;
    }

    @Override
    public QueryColumn add(Number number) {
        this.arithmeticInfos.add(new ArithmeticInfo(" + ", number));
        return this;
    }

    @Override
    public QueryColumn subtract(QueryColumn queryColumn) {
        this.arithmeticInfos.add(new ArithmeticInfo(" - ", queryColumn));
        return this;
    }

    @Override
    public QueryColumn subtract(Number number) {
        this.arithmeticInfos.add(new ArithmeticInfo(" - ", number));
        return this;
    }

    @Override
    public QueryColumn multiply(QueryColumn queryColumn) {
        this.arithmeticInfos.add(new ArithmeticInfo(" * ", queryColumn));
        return this;
    }

    @Override
    public QueryColumn multiply(Number number) {
        this.arithmeticInfos.add(new ArithmeticInfo(" * ", number));
        return this;
    }

    @Override
    public QueryColumn divide(QueryColumn queryColumn) {
        this.arithmeticInfos.add(new ArithmeticInfo(" / ", queryColumn));
        return this;
    }

    @Override
    public QueryColumn divide(Number number) {
        this.arithmeticInfos.add(new ArithmeticInfo(" / ", number));
        return this;
    }

    @Override
    String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < this.arithmeticInfos.size(); ++i) {
            sql.append(this.arithmeticInfos.get(i).toSql(queryTables, dialect, i));
        }
        if (StringUtil.isNotBlank(this.alias)) {
            return WrapperUtil.withAlias(sql.toString(), this.alias, dialect);
        }
        return sql.toString();
    }

    @Override
    public ArithmeticQueryColumn clone() {
        ArithmeticQueryColumn clone = (ArithmeticQueryColumn)super.clone();
        clone.arithmeticInfos = CollectionUtil.cloneArrayList(this.arithmeticInfos);
        return clone;
    }

    @Override
    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < this.arithmeticInfos.size(); ++i) {
            sql.append(this.arithmeticInfos.get(i).toSql(queryTables, dialect, i));
        }
        return "(" + sql + ")";
    }

    static class ArithmeticInfo
    implements CloneSupport<ArithmeticInfo> {
        private String symbol;
        private Object value;

        public ArithmeticInfo(Object value) {
            this(null, value);
        }

        public ArithmeticInfo(String symbol, Object value) {
            this.symbol = symbol;
            this.value = value;
        }

        private String toSql(List<QueryTable> queryTables, IDialect dialect, int index) {
            String valueSql = this.value instanceof QueryColumn ? ((QueryColumn)this.value).toConditionSql(queryTables, dialect) : String.valueOf(this.value);
            return index == 0 ? valueSql : this.symbol + valueSql;
        }

        @Override
        public ArithmeticInfo clone() {
            try {
                return (ArithmeticInfo)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw FlexExceptions.wrap(e);
            }
        }
    }
}

