/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.dialect.impl.OracleDialect;
import com.mybatisflex.core.query.Brackets;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.RawFragment;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.EnumWrapper;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class WrapperUtil {
    private WrapperUtil() {
    }

    static List<QueryWrapper> getChildQueryWrapper(QueryCondition condition) {
        ArrayList<QueryWrapper> list = null;
        while (condition != null) {
            if (condition.checkEffective()) {
                if (condition instanceof Brackets) {
                    List<QueryWrapper> childQueryWrapper = WrapperUtil.getChildQueryWrapper(((Brackets)condition).getChildCondition());
                    if (!childQueryWrapper.isEmpty()) {
                        if (list == null) {
                            list = new ArrayList();
                        }
                        list.addAll(childQueryWrapper);
                    }
                } else {
                    Object value = condition.getValue();
                    if (value instanceof QueryWrapper) {
                        if (list == null) {
                            list = new ArrayList<QueryWrapper>();
                        }
                        list.add((QueryWrapper)value);
                        list.addAll(((QueryWrapper)value).getChildSelect());
                    } else if (value != null && value.getClass().isArray()) {
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            Object arrayValue = Array.get(value, i);
                            if (!(arrayValue instanceof QueryWrapper)) continue;
                            if (list == null) {
                                list = new ArrayList();
                            }
                            list.add((QueryWrapper)arrayValue);
                            list.addAll(((QueryWrapper)arrayValue).getChildSelect());
                        }
                    }
                }
            }
            condition = condition.next;
        }
        return list == null ? Collections.emptyList() : list;
    }

    static Object[] getValues(QueryCondition condition) {
        if (condition == null) {
            return FlexConsts.EMPTY_ARRAY;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        WrapperUtil.getValues(condition, params);
        return params.isEmpty() ? FlexConsts.EMPTY_ARRAY : params.toArray();
    }

    private static void getValues(QueryCondition condition, List<Object> params) {
        if (condition == null) {
            return;
        }
        Object value = condition.getValue();
        if (value == null || value instanceof QueryColumn || value instanceof RawFragment) {
            WrapperUtil.getValues(condition.next, params);
            return;
        }
        WrapperUtil.addParam(params, value);
        WrapperUtil.getValues(condition.next, params);
    }

    private static void addParam(List<Object> paras, Object value) {
        if (value == null) {
            paras.add(null);
        } else if (ClassUtil.isArray(value.getClass())) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                WrapperUtil.addParam(paras, Array.get(value, i));
            }
        } else if (value instanceof QueryWrapper) {
            Object[] valueArray = ((QueryWrapper)value).getAllValueArray();
            paras.addAll(Arrays.asList(valueArray));
        } else if (value.getClass().isEnum()) {
            EnumWrapper enumWrapper = EnumWrapper.of(value.getClass());
            if (enumWrapper.hasEnumValueAnnotation()) {
                paras.add(enumWrapper.getEnumValue((Enum)value));
            } else {
                paras.add(((Enum)value).name());
            }
        } else {
            paras.add(value);
        }
    }

    static String buildValue(Object value) {
        if (value instanceof Number || value instanceof Boolean) {
            return String.valueOf(value);
        }
        if (value instanceof RawFragment) {
            return ((RawFragment)value).getContent();
        }
        if (value instanceof QueryColumn) {
            return ((QueryColumn)value).toConditionSql(null, DialectFactory.getDialect());
        }
        return "'" + value + "'";
    }

    static String withBracket(String sql) {
        return "(" + sql + ")";
    }

    static String withAlias(String sql, String alias, IDialect dialect) {
        return "(" + sql + ")" + WrapperUtil.getAsKeyWord(dialect) + dialect.wrap(alias);
    }

    static String buildAlias(String alias, IDialect dialect) {
        return StringUtil.isBlank(alias) ? "" : WrapperUtil.getAsKeyWord(dialect) + dialect.wrap(alias);
    }

    private static String getAsKeyWord(IDialect dialect) {
        return dialect instanceof OracleDialect ? " " : " AS ";
    }
}

