/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.handler;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mybatisflex.core.handler.BaseJsonTypeHandler;
import java.lang.reflect.Type;

public class GsonTypeHandler
extends BaseJsonTypeHandler<Object> {
    private static Gson gson;
    private final Class<?> propertyType;
    private Class<?> genericType;

    public GsonTypeHandler(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public GsonTypeHandler(Class<?> propertyType, Class<?> genericType) {
        this.propertyType = propertyType;
        this.genericType = genericType;
    }

    @Override
    protected Object parseJson(String json) {
        if (this.genericType != null) {
            TypeToken typeToken = TypeToken.getParameterized(this.propertyType, (Type[])new Type[]{this.genericType});
            return GsonTypeHandler.getGson().fromJson(json, typeToken);
        }
        return GsonTypeHandler.getGson().fromJson(json, this.propertyType);
    }

    @Override
    protected String toJson(Object object) {
        return GsonTypeHandler.getGson().toJson(object);
    }

    public static Gson getGson() {
        if (null == gson) {
            gson = new Gson();
        }
        return gson;
    }

    public static void setGson(Gson gson) {
        GsonTypeHandler.gson = gson;
    }
}

