/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.constant.SqlConnector;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class Brackets
extends QueryCondition {
    private QueryCondition childCondition;

    public Brackets(QueryCondition childCondition) {
        this.childCondition = childCondition;
    }

    @Override
    public QueryColumn getColumn() {
        return this.childCondition.getColumn();
    }

    @Override
    public void setColumn(QueryColumn column) {
        this.childCondition.setColumn(column);
    }

    @Override
    public void setValue(Object value) {
        this.childCondition.setValue(value);
    }

    @Override
    public String getLogic() {
        return this.childCondition.getLogic();
    }

    @Override
    public void setLogic(String logic) {
        this.childCondition.setLogic(logic);
    }

    @Override
    protected QueryCondition getNextEffectiveCondition() {
        return this.childCondition.getNextEffectiveCondition();
    }

    @Override
    public QueryCondition and(QueryCondition nextCondition) {
        this.connectToChild(nextCondition, SqlConnector.AND);
        return this;
    }

    @Override
    public QueryCondition or(QueryCondition nextCondition) {
        this.connectToChild(nextCondition, SqlConnector.OR);
        return this;
    }

    protected void connectToChild(QueryCondition nextCondition, SqlConnector connector) {
        this.childCondition.connect(nextCondition, connector);
    }

    @Override
    public Object getValue() {
        return this.checkEffective() ? WrapperUtil.getValues(this.childCondition) : null;
    }

    public QueryCondition getChildCondition() {
        return this.childCondition;
    }

    @Override
    public boolean checkEffective() {
        boolean effective = super.checkEffective();
        if (!effective) {
            return false;
        }
        QueryCondition condition = this.childCondition;
        while (condition != null) {
            if (condition.checkEffective()) {
                return true;
            }
            condition = condition.next;
        }
        return false;
    }

    @Override
    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        String sqlNext = this.next == null ? null : this.next.toSql(queryTables, dialect);
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective()) {
            String childSql = this.childCondition.toSql(queryTables, dialect);
            if (StringUtil.isNotBlank(childSql)) {
                QueryCondition prevEffectiveCondition = this.getPrevEffectiveCondition();
                if (prevEffectiveCondition != null) {
                    childSql = (Object)((Object)prevEffectiveCondition.connector) + "(" + childSql + ")";
                } else if (StringUtil.isNotBlank(sqlNext)) {
                    childSql = "(" + childSql + ")";
                }
                sql.append(childSql);
            } else {
                this.effective = false;
            }
        }
        return sqlNext != null ? sql + sqlNext : sql.toString();
    }

    @Override
    boolean containsTable(String ... tables) {
        if (this.childCondition != null && this.childCondition.containsTable(tables)) {
            return true;
        }
        return this.nextContainsTable(tables);
    }

    @Override
    public String toString() {
        return "Brackets{childCondition=" + this.childCondition + '}';
    }

    @Override
    public Brackets clone() {
        Brackets clone = (Brackets)super.clone();
        clone.childCondition = ObjectUtil.clone(this.childCondition);
        return clone;
    }
}

