/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.table;

import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.io.ResolverUtil;

public class TableDefs
implements Serializable {
    private static final Map<String, TableDef> TABLE_DEF_MAP = new HashMap<String, TableDef>();
    private static final Map<String, Map<String, QueryColumn>> QUERY_COLUMN_MAP = new HashMap<String, Map<String, QueryColumn>>();

    public static void init(String packageName) {
        ResolverUtil resolverUtil = new ResolverUtil();
        resolverUtil.find((ResolverUtil.Test)new ResolverUtil.IsA(TableDef.class), packageName);
        Set typeSet = resolverUtil.getClasses();
        for (Class type : typeSet) {
            if (type.isAnonymousClass() || type.isInterface() || type.isMemberClass()) continue;
            try {
                TableDefs.registerTableDef(type);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static TableDef getTableDef(Class<?> entityClass, String tableNameWithSchema) {
        TableDef tableDef = TABLE_DEF_MAP.get(tableNameWithSchema);
        if (tableDef == null) {
            TableDefs.init(entityClass.getPackage().getName());
            tableDef = TABLE_DEF_MAP.get(tableNameWithSchema);
        }
        return tableDef;
    }

    public static QueryColumn getQueryColumn(Class<?> entityClass, String tableNameWithSchema, String column) {
        Map<String, QueryColumn> queryColumnMap = QUERY_COLUMN_MAP.get(tableNameWithSchema);
        if (queryColumnMap == null) {
            TableDefs.init(entityClass.getPackage().getName());
            queryColumnMap = QUERY_COLUMN_MAP.get(tableNameWithSchema);
        }
        return queryColumnMap != null ? queryColumnMap.get(column) : null;
    }

    public static void registerTableDef(Class<?> tableDefClass) throws IllegalAccessException {
        TableDef tableDef = (TableDef)ClassUtil.getFirstField(tableDefClass, field -> {
            int mod = Modifier.fieldModifiers();
            return Modifier.isPublic(mod) && Modifier.isStatic(mod);
        }).get(null);
        String key = StringUtil.buildSchemaWithTable(tableDef.getSchema(), tableDef.getTableName());
        TABLE_DEF_MAP.put(key, tableDef);
        List<Field> allFields = ClassUtil.getAllFields(tableDef.getClass(), field -> field.getType() == QueryColumn.class);
        HashMap<String, QueryColumn> columnMap = new HashMap<String, QueryColumn>(allFields.size());
        for (Field field2 : allFields) {
            QueryColumn queryColumn = (QueryColumn)field2.get(tableDef);
            columnMap.put(queryColumn.getName(), queryColumn);
        }
        QUERY_COLUMN_MAP.put(key, columnMap);
    }
}

