/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.dialect.DbType;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.field.FieldQuery;
import com.mybatisflex.core.field.FieldQueryBuilder;
import com.mybatisflex.core.field.FieldQueryManager;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.DistinctQueryColumn;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryMethods;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.relation.RelationManager;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.ibatis.exceptions.TooManyResultsException;

public class MapperUtil {
    private MapperUtil() {
    }

    public static QueryWrapper rawCountQueryWrapper(QueryWrapper queryWrapper) {
        return QueryWrapper.create().select(QueryMethods.count().as("total")).from(queryWrapper).as("t");
    }

    public static QueryWrapper optimizeCountQueryWrapper(QueryWrapper queryWrapper) {
        QueryWrapper clone = queryWrapper.clone();
        CPI.setOrderBys(clone, null);
        List<QueryColumn> selectColumns = CPI.getSelectColumns(clone);
        List<QueryColumn> groupByColumns = CPI.getGroupByColumns(clone);
        if (MapperUtil.hasDistinct(selectColumns) || MapperUtil.hasGroupBy(groupByColumns)) {
            return MapperUtil.rawCountQueryWrapper(clone);
        }
        if (MapperUtil.canClearJoins(clone)) {
            CPI.setJoins(clone, null);
        }
        CPI.setSelectColumns(clone, Collections.singletonList(QueryMethods.count().as("total")));
        return clone;
    }

    public static boolean hasDistinct(List<QueryColumn> selectColumns) {
        if (CollectionUtil.isEmpty(selectColumns)) {
            return false;
        }
        for (QueryColumn selectColumn : selectColumns) {
            if (!(selectColumn instanceof DistinctQueryColumn)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasGroupBy(List<QueryColumn> groupByColumns) {
        return CollectionUtil.isNotEmpty(groupByColumns);
    }

    private static boolean canClearJoins(QueryWrapper queryWrapper) {
        List<Join> joins = CPI.getJoins(queryWrapper);
        if (CollectionUtil.isEmpty(joins)) {
            return false;
        }
        for (Join join2 : joins) {
            if (" LEFT JOIN ".equals(CPI.getJoinType(join2))) continue;
            return false;
        }
        ArrayList joinTables = new ArrayList();
        joins.forEach(join -> {
            QueryTable joinQueryTable = CPI.getJoinQueryTable(join);
            if (joinQueryTable != null) {
                String tableName = joinQueryTable.getName();
                if (StringUtil.isNotBlank(joinQueryTable.getAlias())) {
                    joinTables.add(tableName + "." + joinQueryTable.getAlias());
                } else {
                    joinTables.add(tableName);
                }
            }
        });
        QueryCondition where = CPI.getWhereQueryCondition(queryWrapper);
        return !CPI.containsTable(where, CollectionUtil.toArrayString(joinTables));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public static <T, R> Page<R> doPaginate(BaseMapper<T> mapper, Page<R> page, QueryWrapper queryWrapper, Class<R> asType, boolean withRelations, Consumer<FieldQueryBuilder<R>> ... consumers) {
        try {
            Serializable countQueryWrapper;
            if (page.getTotalRow() < 0L) {
                countQueryWrapper = page.needOptimizeCountQuery() ? MapperUtil.optimizeCountQueryWrapper(queryWrapper) : MapperUtil.rawCountQueryWrapper(queryWrapper);
                page.setTotalRow(mapper.selectCountByQuery((QueryWrapper)countQueryWrapper));
            }
            if (!page.hasRecords()) {
                countQueryWrapper = page;
                return countQueryWrapper;
            }
            queryWrapper.limit(page.offset(), page.getPageSize());
            List<Object> records = asType != null ? mapper.selectListByQueryAs(queryWrapper, asType) : mapper.selectListByQuery(queryWrapper);
            if (withRelations) {
                MapperUtil.queryRelations(mapper, records);
            }
            MapperUtil.queryFields(mapper, records, consumers);
            page.setRecords(records);
            Page<R> page2 = page;
            return page2;
        }
        finally {
            CPI.setLimitRows(queryWrapper, null);
            CPI.setLimitOffset(queryWrapper, null);
        }
    }

    public static <R> void queryFields(BaseMapper<?> mapper, List<R> list, Consumer<FieldQueryBuilder<R>>[] consumers) {
        if (CollectionUtil.isEmpty(list) || ArrayUtil.isEmpty(consumers) || consumers[0] == null) {
            return;
        }
        HashMap<String, FieldQuery> fieldQueryMap = new HashMap<String, FieldQuery>();
        for (Consumer<FieldQueryBuilder<R>> consumer : consumers) {
            FieldQueryBuilder fieldQueryBuilder = new FieldQueryBuilder();
            consumer.accept(fieldQueryBuilder);
            FieldQuery fieldQuery = fieldQueryBuilder.build();
            String className = fieldQuery.getEntityClass().getName();
            String fieldName = fieldQuery.getFieldName();
            String mapKey = className + '#' + fieldName;
            fieldQueryMap.put(mapKey, fieldQuery);
        }
        FieldQueryManager.queryFields(mapper, list, fieldQueryMap);
    }

    public static <E> E queryRelations(BaseMapper<?> mapper, E entity) {
        if (entity != null) {
            MapperUtil.queryRelations(mapper, Collections.singletonList(entity));
        }
        return entity;
    }

    public static <E> List<E> queryRelations(BaseMapper<?> mapper, List<E> entities) {
        RelationManager.queryRelations(mapper, entities);
        return entities;
    }

    public static Class<? extends Collection> getCollectionWrapType(Class<?> type) {
        if (ClassUtil.canInstance(type.getModifiers())) {
            return type;
        }
        if (List.class.isAssignableFrom(type)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return HashSet.class;
        }
        throw new IllegalStateException("Field query can not support type: " + type.getName());
    }

    public static <T> T getSelectOneResult(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        if (size == 1) {
            return list.get(0);
        }
        throw new TooManyResultsException("Expected one result (or null) to be returned by selectOne(), but found: " + size);
    }

    public static long getLongNumber(List<Object> objects) {
        Object object;
        Object object2 = object = objects == null || objects.isEmpty() ? null : objects.get(0);
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw FlexExceptions.wrap("selectCountByQuery error, can not get number value of result: \"" + object + "\"", new Object[0]);
    }

    public static Map<String, Object> preparedParams(Page<?> page, QueryWrapper queryWrapper, Map<String, Object> params) {
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        if (params != null) {
            newParams.putAll(params);
        }
        newParams.put("pageOffset", page.offset());
        newParams.put("pageNumber", page.getPageNumber());
        newParams.put("pageSize", page.getPageSize());
        DbType dbType = DialectFactory.getHintDbType();
        newParams.put("dbType", (Object)(dbType != null ? dbType : FlexGlobalConfig.getDefaultConfig().getDbType()));
        if (queryWrapper != null) {
            MapperUtil.preparedQueryWrapper(newParams, queryWrapper);
        }
        return newParams;
    }

    private static void preparedQueryWrapper(Map<String, Object> params, QueryWrapper queryWrapper) {
        String sql = DialectFactory.getDialect().buildNoSelectSql(queryWrapper);
        StringBuilder sqlBuilder = new StringBuilder();
        char quote = '\u0000';
        int index = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '\'') {
                if (quote == '\u0000') {
                    quote = ch;
                } else if (quote == '\'') {
                    quote = '\u0000';
                }
            } else if (ch == '\"') {
                if (quote == '\u0000') {
                    quote = ch;
                } else if (quote == '\"') {
                    quote = '\u0000';
                }
            }
            if (quote == '\u0000' && ch == '?') {
                sqlBuilder.append("#{qwParams_").append(index++).append("}");
                continue;
            }
            sqlBuilder.append(ch);
        }
        params.put("qwSql", sqlBuilder.toString());
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        for (int i = 0; i < valueArray.length; ++i) {
            params.put("qwParams_" + i, valueArray[i]);
        }
    }
}

