/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import java.util.Objects;
import java.util.function.Predicate;

public class QueryColumnBehavior {
    public static final Predicate<Object> IGNORE_NULL = Objects::isNull;
    public static final Predicate<Object> IGNORE_EMPTY = o -> o == null || "".equals(o);
    public static final Predicate<Object> IGNORE_BLANK = o -> o == null || "".equals(o.toString().trim());
    private static Predicate<Object> ignoreFunction = IGNORE_NULL;
    private static boolean smartConvertInToEquals = false;

    private QueryColumnBehavior() {
    }

    public static Predicate<Object> getIgnoreFunction() {
        return ignoreFunction;
    }

    public static void setIgnoreFunction(Predicate<Object> ignoreFunction) {
        QueryColumnBehavior.ignoreFunction = ignoreFunction;
    }

    public static boolean isSmartConvertInToEquals() {
        return smartConvertInToEquals;
    }

    public static void setSmartConvertInToEquals(boolean smartConvertInToEquals) {
        QueryColumnBehavior.smartConvertInToEquals = smartConvertInToEquals;
    }

    static boolean shouldIgnoreValue(Object value) {
        return ignoreFunction.test(value);
    }
}

