/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.Objects;

public class RawQueryTable
extends QueryTable {
    protected String content;

    public RawQueryTable(String content) {
        this.content = content;
    }

    @Override
    public String toSql(IDialect dialect) {
        return this.content + WrapperUtil.buildAlias(this.alias, dialect);
    }

    @Override
    boolean isSameTable(QueryTable table) {
        if (table == null) {
            return false;
        }
        if (StringUtil.isNotBlank(this.alias) && StringUtil.isNotBlank(table.alias)) {
            return Objects.equals(this.alias, table.alias);
        }
        return false;
    }

    @Override
    public String toString() {
        return "RawQueryTable{content='" + this.content + '\'' + '}';
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public RawQueryTable clone() {
        return (RawQueryTable)super.clone();
    }
}

