/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit;

import com.mybatisflex.core.audit.AuditMessage;
import com.mybatisflex.core.audit.Clock;
import com.mybatisflex.core.audit.DefaultMessageFactory;
import com.mybatisflex.core.audit.MessageCollector;
import com.mybatisflex.core.audit.MessageFactory;
import com.mybatisflex.core.audit.MessageReporter;
import com.mybatisflex.core.audit.ScheduledMessageCollector;
import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.util.StringUtil;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class AuditManager {
    private static MessageFactory messageFactory = new DefaultMessageFactory();
    private static boolean auditEnable = false;
    private static Clock clock = System::currentTimeMillis;
    private static MessageCollector messageCollector = new ScheduledMessageCollector();

    private AuditManager() {
    }

    public static boolean isAuditEnable() {
        return auditEnable;
    }

    public static void setAuditEnable(boolean auditEnable) {
        AuditManager.auditEnable = auditEnable;
    }

    public static Clock getClock() {
        return clock;
    }

    public static void setClock(Clock clock) {
        AuditManager.clock = clock;
    }

    public static MessageFactory getMessageFactory() {
        return messageFactory;
    }

    public static void setMessageFactory(MessageFactory messageFactory) {
        AuditManager.messageFactory = messageFactory;
    }

    public static MessageCollector getMessageCollector() {
        return messageCollector;
    }

    public static void setMessageReporter(MessageReporter messageReporter) {
        ScheduledMessageCollector newMessageCollector = new ScheduledMessageCollector(10L, messageReporter);
        AuditManager.setMessageCollector(newMessageCollector);
    }

    public static void setMessageCollector(MessageCollector messageCollector) {
        MessageCollector temp = AuditManager.messageCollector;
        AuditManager.messageCollector = messageCollector;
        AuditManager.releaseScheduledMessageCollector(temp);
    }

    private static void releaseScheduledMessageCollector(MessageCollector messageCollector) {
        if (messageCollector instanceof ScheduledMessageCollector) {
            ((ScheduledMessageCollector)messageCollector).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T startAudit(AuditRunnable<T> supplier, Statement statement, BoundSql boundSql, Configuration configuration) throws SQLException {
        T t;
        AuditMessage auditMessage = messageFactory.create();
        if (auditMessage == null) {
            return supplier.execute();
        }
        String key = DataSourceKey.get();
        if (StringUtil.isNotBlank(key)) {
            auditMessage.setDsName(key);
        }
        auditMessage.setQueryTime(clock.getTick());
        try {
            T result = supplier.execute();
            if (result instanceof Collection) {
                auditMessage.setQueryCount(((Collection)result).size());
            } else if (result instanceof Number) {
                auditMessage.setQueryCount(((Number)result).intValue());
            } else if (result != null) {
                auditMessage.setQueryCount(1);
            }
            t = result;
            auditMessage.setElapsedTime(clock.getTick() - auditMessage.getQueryTime());
            auditMessage.setQuery(boundSql.getSql());
        }
        catch (Throwable throwable) {
            auditMessage.setElapsedTime(clock.getTick() - auditMessage.getQueryTime());
            auditMessage.setQuery(boundSql.getSql());
            Object parameter = boundSql.getParameterObject();
            if (parameter instanceof Map) {
                TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
                if (((Map)parameter).containsKey("$$sql_args")) {
                    auditMessage.addParams(statement, ((Map)parameter).get("$$sql_args"));
                } else if (((Map)parameter).containsKey("collection")) {
                    Collection collection = (Collection)((Map)parameter).get("collection");
                    auditMessage.addParams(statement, collection.toArray());
                } else if (((Map)parameter).containsKey("array")) {
                    auditMessage.addParams(statement, ((Map)parameter).get("array"));
                } else {
                    List parameterMappings = boundSql.getParameterMappings();
                    for (ParameterMapping parameterMapping : parameterMappings) {
                        Object value;
                        if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                        String propertyName = parameterMapping.getProperty();
                        if (boundSql.hasAdditionalParameter(propertyName)) {
                            value = boundSql.getAdditionalParameter(propertyName);
                        } else if (typeHandlerRegistry.hasTypeHandler(parameter.getClass())) {
                            value = parameter;
                        } else {
                            MetaObject metaObject = configuration.newMetaObject(parameter);
                            value = metaObject.getValue(propertyName);
                        }
                        auditMessage.addParams(statement, value);
                    }
                }
            }
            messageCollector.collect(auditMessage);
            throw throwable;
        }
        Object parameter = boundSql.getParameterObject();
        if (parameter instanceof Map) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (((Map)parameter).containsKey("$$sql_args")) {
                auditMessage.addParams(statement, ((Map)parameter).get("$$sql_args"));
            } else if (((Map)parameter).containsKey("collection")) {
                Collection collection = (Collection)((Map)parameter).get("collection");
                auditMessage.addParams(statement, collection.toArray());
            } else if (((Map)parameter).containsKey("array")) {
                auditMessage.addParams(statement, ((Map)parameter).get("array"));
            } else {
                List parameterMappings = boundSql.getParameterMappings();
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object value;
                    if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                    String propertyName = parameterMapping.getProperty();
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        value = boundSql.getAdditionalParameter(propertyName);
                    } else if (typeHandlerRegistry.hasTypeHandler(parameter.getClass())) {
                        value = parameter;
                    } else {
                        MetaObject metaObject = configuration.newMetaObject(parameter);
                        value = metaObject.getValue(propertyName);
                    }
                    auditMessage.addParams(statement, value);
                }
            }
        }
        messageCollector.collect(auditMessage);
        return t;
    }

    @FunctionalInterface
    public static interface AuditRunnable<T> {
        public T execute() throws SQLException;
    }
}

