/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.AbstractQueryBuilder;
import com.mybatisflex.core.query.MapperQueryChain;
import com.mybatisflex.core.relation.RelationManager;
import com.mybatisflex.core.util.LambdaGetter;
import java.util.List;

public class RelationsBuilder<T>
extends AbstractQueryBuilder<T> {
    public RelationsBuilder(MapperQueryChain<T> delegate) {
        super(delegate);
    }

    public RelationsBuilder<T> ignoreRelations(String ... fields) {
        RelationManager.addIgnoreRelations(fields);
        return this;
    }

    public <L> RelationsBuilder<T> ignoreRelations(LambdaGetter<L> ... fields) {
        RelationManager.addIgnoreRelations(fields);
        return this;
    }

    public RelationsBuilder<T> maxDepth(int maxDepth) {
        RelationManager.setMaxDepth(maxDepth);
        return this;
    }

    public RelationsBuilder<T> extraConditionParam(String key, Object value) {
        RelationManager.addExtraConditionParam(key, value);
        return this;
    }

    @Override
    public T one() {
        return this.baseMapper().selectOneWithRelationsByQuery(this.queryWrapper());
    }

    @Override
    public <R> R oneAs(Class<R> asType) {
        return this.baseMapper().selectOneWithRelationsByQueryAs(this.queryWrapper(), asType);
    }

    @Override
    public List<T> list() {
        return this.baseMapper().selectListWithRelationsByQuery(this.queryWrapper());
    }

    @Override
    public <R> List<R> listAs(Class<R> asType) {
        return this.baseMapper().selectListWithRelationsByQueryAs(this.queryWrapper(), asType);
    }

    @Override
    public Page<T> page(Page<T> page) {
        return this.baseMapper().paginateWithRelations(page, this.queryWrapper());
    }

    @Override
    public <R> Page<R> pageAs(Page<R> page, Class<R> asType) {
        return this.baseMapper().paginateWithRelationsAs(page, this.queryWrapper(), asType);
    }
}

