/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.util.DateUtil;
import com.mybatisflex.core.util.EnumWrapper;
import com.mybatisflex.core.util.StringUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Date;

public class ConvertUtil {
    private ConvertUtil() {
    }

    public static Object convert(Object value, Class targetClass) {
        return ConvertUtil.convert(value, targetClass, false);
    }

    public static Object convert(Object value, Class targetClass, boolean ignoreConvertError) {
        if (value == null && targetClass.isPrimitive()) {
            return ConvertUtil.getPrimitiveDefaultValue(targetClass);
        }
        if (value == null || targetClass != String.class && value.getClass() == String.class && StringUtil.isBlank((String)value)) {
            return null;
        }
        if (value.getClass().isAssignableFrom(targetClass)) {
            return value;
        }
        if (targetClass == String.class) {
            return value.toString();
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
            String v = value.toString().toLowerCase();
            if ("1".equals(v) || "true".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("0".equals(v) || "false".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Can not parse to boolean type of value: \"" + value + "\"");
        }
        if (targetClass == BigDecimal.class) {
            return new BigDecimal(value.toString());
        }
        if (targetClass == BigInteger.class) {
            return new BigInteger(value.toString());
        }
        if (targetClass == byte[].class) {
            return value.toString().getBytes();
        }
        if (targetClass == Date.class) {
            return DateUtil.parseDate(value);
        }
        if (targetClass == LocalDateTime.class) {
            return ConvertUtil.toLocalDateTime(value);
        }
        if (targetClass == LocalDate.class) {
            return DateUtil.toLocalDate(DateUtil.parseDate(value));
        }
        if (targetClass == LocalTime.class) {
            return DateUtil.toLocalTime(DateUtil.parseDate(value));
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(value.toString());
        }
        if (targetClass.isEnum()) {
            EnumWrapper enumWrapper = EnumWrapper.of(targetClass);
            if (enumWrapper.hasEnumValueAnnotation()) {
                return enumWrapper.getEnum(value);
            }
            if (value instanceof String) {
                return Enum.valueOf(targetClass, value.toString());
            }
        }
        if (ignoreConvertError) {
            return null;
        }
        throw new IllegalArgumentException("Can not convert \"" + value + "\" to type\"" + targetClass.getName() + "\".");
    }

    public static Object getPrimitiveDefaultValue(Class<?> paraClass) {
        if (paraClass == Integer.TYPE || paraClass == Long.TYPE || paraClass == Float.TYPE || paraClass == Double.TYPE) {
            return 0;
        }
        if (paraClass == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (paraClass == Short.TYPE) {
            return (short)0;
        }
        if (paraClass == Byte.TYPE) {
            return (byte)0;
        }
        if (paraClass == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Can not get primitive default value for type: " + paraClass);
    }

    public static Class<?> primitiveToBoxed(Class<?> paraClass) {
        if (paraClass == Integer.TYPE) {
            return Integer.class;
        }
        if (paraClass == Long.TYPE) {
            return Long.class;
        }
        if (paraClass == Double.TYPE) {
            return Double.class;
        }
        if (paraClass == Float.TYPE) {
            return Float.class;
        }
        if (paraClass == Boolean.TYPE) {
            return Boolean.class;
        }
        if (paraClass == Short.TYPE) {
            return Short.class;
        }
        if (paraClass == Byte.TYPE) {
            return Byte.class;
        }
        if (paraClass == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Can not convert primitive class for type: " + paraClass);
    }

    public static Integer toInt(Object i) {
        if (i instanceof Integer) {
            return (Integer)i;
        }
        if (i instanceof Number) {
            return ((Number)i).intValue();
        }
        return i != null ? Integer.valueOf(Integer.parseInt(i.toString())) : null;
    }

    public static Long toLong(Object l) {
        if (l instanceof Long) {
            return (Long)l;
        }
        if (l instanceof Number) {
            return ((Number)l).longValue();
        }
        return l != null ? Long.valueOf(Long.parseLong(l.toString())) : null;
    }

    public static Double toDouble(Object d) {
        if (d instanceof Double) {
            return (Double)d;
        }
        if (d instanceof Number) {
            return ((Number)d).doubleValue();
        }
        return d != null ? Double.valueOf(Double.parseDouble(d.toString())) : null;
    }

    public static BigDecimal toBigDecimal(Object b) {
        if (b instanceof BigDecimal) {
            return (BigDecimal)b;
        }
        if (b != null) {
            return new BigDecimal(b.toString());
        }
        return null;
    }

    public static BigInteger toBigInteger(Object b) {
        if (b instanceof BigInteger) {
            return (BigInteger)b;
        }
        if (b instanceof BigDecimal) {
            return ((BigDecimal)b).toBigInteger();
        }
        if (b instanceof Number) {
            return BigInteger.valueOf(((Number)b).longValue());
        }
        if (b instanceof String) {
            return new BigInteger((String)b);
        }
        return (BigInteger)b;
    }

    public static Float toFloat(Object f) {
        if (f instanceof Float) {
            return (Float)f;
        }
        if (f instanceof Number) {
            return Float.valueOf(((Number)f).floatValue());
        }
        return f != null ? Float.valueOf(Float.parseFloat(f.toString())) : null;
    }

    public static Short toShort(Object s) {
        if (s instanceof Short) {
            return (Short)s;
        }
        if (s instanceof Number) {
            return ((Number)s).shortValue();
        }
        return s != null ? Short.valueOf(Short.parseShort(s.toString())) : null;
    }

    public static Byte toByte(Object b) {
        if (b instanceof Byte) {
            return (Byte)b;
        }
        if (b instanceof Number) {
            return ((Number)b).byteValue();
        }
        return b != null ? Byte.valueOf(Byte.parseByte(b.toString())) : null;
    }

    public static Boolean toBoolean(Object b) {
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        if (b == null) {
            return null;
        }
        if (b instanceof Number) {
            int n = ((Number)b).intValue();
            if (n == 1) {
                return Boolean.TRUE;
            }
            if (n == 0) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Can not support convert: \"" + b + "\" to boolean.");
        }
        if (b instanceof String) {
            String s = b.toString();
            if ("true".equalsIgnoreCase(s) || "1".equals(s)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(s) || "0".equals(s)) {
                return Boolean.FALSE;
            }
        }
        return (Boolean)b;
    }

    public static Date toDate(Object o) {
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Temporal) {
            if (o instanceof LocalDateTime) {
                return DateUtil.toDate((LocalDateTime)o);
            }
            if (o instanceof LocalDate) {
                return DateUtil.toDate((LocalDate)o);
            }
            if (o instanceof LocalTime) {
                return DateUtil.toDate((LocalTime)o);
            }
        }
        if (o instanceof String) {
            String s = (String)o;
            return DateUtil.parseDate(s);
        }
        return (Date)o;
    }

    public static LocalDateTime toLocalDateTime(Object o) {
        if (o instanceof LocalDateTime) {
            return (LocalDateTime)o;
        }
        if (o instanceof Date) {
            return DateUtil.toLocalDateTime((Date)o);
        }
        if (o instanceof LocalDate) {
            return ((LocalDate)o).atStartOfDay();
        }
        if (o instanceof LocalTime) {
            return LocalDateTime.of(LocalDate.now(), (LocalTime)o);
        }
        if (o instanceof String) {
            String s = (String)o;
            return DateUtil.parseLocalDateTime(s);
        }
        return (LocalDateTime)o;
    }
}

