/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.mybatis.TypeHandlerObject;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class SqlArgsParameterHandler
extends DefaultParameterHandler {
    private final TypeHandlerRegistry typeHandlerRegistry;

    public SqlArgsParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        super(mappedStatement, parameterObject, boundSql);
        this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
    }

    public void setParameters(PreparedStatement ps) {
        try {
            this.doSetParameters(ps);
        }
        catch (SQLException e) {
            throw FlexExceptions.wrap(e);
        }
    }

    private void doSetParameters(PreparedStatement ps) throws SQLException {
        Object[] sqlArgs = (Object[])((Map)this.getParameterObject()).get("$$sql_args");
        if (sqlArgs == null || sqlArgs.length == 0) {
            super.setParameters(ps);
            return;
        }
        int index = 1;
        for (Object value : sqlArgs) {
            if (value == null) {
                ps.setObject(index++, null);
                continue;
            }
            if (value instanceof TypeHandlerObject) {
                ((TypeHandlerObject)value).setParameter(ps, index++);
                continue;
            }
            TypeHandler typeHandler = this.typeHandlerRegistry.getTypeHandler(value.getClass());
            if (typeHandler == null) {
                typeHandler = this.typeHandlerRegistry.getUnknownTypeHandler();
            }
            typeHandler.setParameter(ps, index++, value, null);
        }
    }
}

