/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.datasource;

import com.mybatisflex.core.datasource.AbstractDataSource;
import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.datasource.DataSourceManager;
import com.mybatisflex.core.dialect.DbType;
import com.mybatisflex.core.dialect.DbTypeUtil;
import com.mybatisflex.core.transaction.TransactionContext;
import com.mybatisflex.core.transaction.TransactionalManager;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.sql.DataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class FlexDataSource
extends AbstractDataSource {
    private static final char LOAD_BALANCE_KEY_SUFFIX = '*';
    private static final Log log = LogFactory.getLog(FlexDataSource.class);
    private final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    private final Map<String, DbType> dbTypeHashMap = new HashMap<String, DbType>();
    private final DbType defaultDbType;
    private final String defaultDataSourceKey;
    private final DataSource defaultDataSource;

    public FlexDataSource(String dataSourceKey, DataSource dataSource) {
        this(dataSourceKey, dataSource, true);
    }

    public FlexDataSource(String dataSourceKey, DataSource dataSource, boolean needDecryptDataSource) {
        if (needDecryptDataSource) {
            DataSourceManager.decryptDataSource(dataSource);
        }
        this.defaultDataSourceKey = dataSourceKey;
        this.defaultDataSource = dataSource;
        this.defaultDbType = DbTypeUtil.getDbType(dataSource);
        this.dataSourceMap.put(dataSourceKey, dataSource);
        this.dbTypeHashMap.put(dataSourceKey, this.defaultDbType);
    }

    public void addDataSource(String dataSourceKey, DataSource dataSource) {
        this.addDataSource(dataSourceKey, dataSource, true);
    }

    public void addDataSource(String dataSourceKey, DataSource dataSource, boolean needDecryptDataSource) {
        if (needDecryptDataSource) {
            DataSourceManager.decryptDataSource(dataSource);
        }
        this.dataSourceMap.put(dataSourceKey, dataSource);
        this.dbTypeHashMap.put(dataSourceKey, DbTypeUtil.getDbType(dataSource));
    }

    public void removeDatasource(String dataSourceKey) {
        this.dataSourceMap.remove(dataSourceKey);
        this.dbTypeHashMap.remove(dataSourceKey);
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public Map<String, DbType> getDbTypeHashMap() {
        return this.dbTypeHashMap;
    }

    public String getDefaultDataSourceKey() {
        return this.defaultDataSourceKey;
    }

    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }

    public DbType getDefaultDbType() {
        return this.defaultDbType;
    }

    public DbType getDbType(String dataSourceKey) {
        return this.dbTypeHashMap.get(dataSourceKey);
    }

    @Override
    public Connection getConnection() throws SQLException {
        String xid = TransactionContext.getXID();
        if (StringUtil.isNotBlank(xid)) {
            Connection connection;
            String dataSourceKey = DataSourceKey.get();
            if (StringUtil.isBlank(dataSourceKey)) {
                dataSourceKey = this.defaultDataSourceKey;
            }
            if ((connection = TransactionalManager.getConnection(xid, dataSourceKey)) == null) {
                connection = this.proxy(this.getDataSource().getConnection(), xid);
                TransactionalManager.hold(xid, dataSourceKey, connection);
            }
            return connection;
        }
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        String xid = TransactionContext.getXID();
        if (StringUtil.isNotBlank(xid)) {
            Connection connection;
            String dataSourceKey = DataSourceKey.get();
            if (StringUtil.isBlank(dataSourceKey)) {
                dataSourceKey = this.defaultDataSourceKey;
            }
            if ((connection = TransactionalManager.getConnection(xid, dataSourceKey)) == null) {
                connection = this.proxy(this.getDataSource().getConnection(username, password), xid);
                TransactionalManager.hold(xid, dataSourceKey, connection);
            }
            return connection;
        }
        return this.getDataSource().getConnection(username, password);
    }

    static void closeAutoCommit(Connection connection) {
        block2: {
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Error set autoCommit to false. Cause: " + e);
            }
        }
    }

    static void resetAutoCommit(Connection connection) {
        block3: {
            try {
                if (!connection.getAutoCommit()) {
                    connection.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Error resetting autoCommit to true before closing the connection. Cause: " + e);
            }
        }
    }

    public Connection proxy(Connection connection, String xid) {
        return (Connection)Proxy.newProxyInstance(FlexDataSource.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionHandler(connection, xid));
    }

    public String getUrl() {
        return DbTypeUtil.getJdbcUrl(this.defaultDataSource);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return this.getDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || this.getDataSource().isWrapperFor(iface);
    }

    private DataSource getDataSource() {
        String dataSourceKey;
        DataSource dataSource = this.defaultDataSource;
        if (this.dataSourceMap.size() > 1 && StringUtil.isNotBlank(dataSourceKey = DataSourceKey.get())) {
            if (dataSourceKey.charAt(dataSourceKey.length() - 1) == '*') {
                String prefix = dataSourceKey.substring(0, dataSourceKey.length() - 1);
                ArrayList<String> matchedKeys = new ArrayList<String>();
                for (String key : this.dataSourceMap.keySet()) {
                    if (!key.startsWith(prefix)) continue;
                    matchedKeys.add(key);
                }
                if (matchedKeys.isEmpty()) {
                    throw new IllegalStateException("Can not matched dataSource by key: \"" + dataSourceKey + "\"");
                }
                String randomKey = (String)matchedKeys.get(ThreadLocalRandom.current().nextInt(matchedKeys.size()));
                return this.dataSourceMap.get(randomKey);
            }
            dataSource = this.dataSourceMap.get(dataSourceKey);
            if (dataSource == null) {
                throw new IllegalStateException("Cannot get target dataSource by key: \"" + dataSourceKey + "\"");
            }
        }
        return dataSource;
    }

    private static class ConnectionHandler
    implements InvocationHandler {
        private static final String[] proxyMethods = new String[]{"commit", "rollback", "close", "setAutoCommit"};
        private final Connection original;
        private final String xid;

        public ConnectionHandler(Connection original, String xid) {
            FlexDataSource.closeAutoCommit(original);
            this.original = original;
            this.xid = xid;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ArrayUtil.contains(proxyMethods, method.getName()) && this.isTransactional()) {
                return null;
            }
            if ("close".equalsIgnoreCase(method.getName())) {
                FlexDataSource.resetAutoCommit(this.original);
            }
            return method.invoke((Object)this.original, args);
        }

        private boolean isTransactional() {
            return Objects.equals(this.xid, TransactionContext.getXID());
        }
    }
}

